/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server.storage;

import java.io.File;
import java.util.Map;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.storage.StorageMedia;
import org.apache.uniffle.guava.collect.Maps;
import org.apache.uniffle.jackson.core.JsonProcessingException;
import org.apache.uniffle.jackson.databind.ObjectMapper;
import org.apache.uniffle.server.ShuffleServerConf;
import org.apache.uniffle.storage.common.StorageMediaProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageMediaFromEnvProvider
implements StorageMediaProvider {
    private static Logger logger = LoggerFactory.getLogger(StorageMediaFromEnvProvider.class);
    private Map<String, StorageMedia> localStorageTypes = Maps.newHashMap();

    public StorageMedia getStorageMediaFor(String baseDir) {
        for (File f = new File(baseDir); f != null; f = f.getParentFile()) {
            if (!this.localStorageTypes.containsKey(f.getPath())) continue;
            return this.localStorageTypes.get(f.getPath());
        }
        return StorageMedia.UNKNOWN;
    }

    public void init(RssConf conf) {
        String envKey = (String)conf.get(ShuffleServerConf.STORAGE_MEDIA_PROVIDER_ENV_KEY);
        String jsonSource = "{}";
        if (envKey != null && System.getenv(envKey) != null) {
            jsonSource = System.getenv(envKey);
        }
        ObjectMapper om = new ObjectMapper();
        try {
            Map mappings = om.readValue(jsonSource, Map.class);
            this.localStorageTypes.clear();
            for (Map.Entry entry : mappings.entrySet()) {
                String basePath = (String)entry.getKey();
                String storageType = (String)entry.getValue();
                try {
                    StorageMedia type = StorageMedia.valueOf((String)storageType.trim().toUpperCase());
                    this.localStorageTypes.put(basePath, type);
                }
                catch (IllegalArgumentException i) {
                    logger.warn("cannot get storage type from {}, ignoring", (Object)storageType);
                }
            }
        }
        catch (JsonProcessingException e) {
            logger.warn("parse json from env failed with exception", (Throwable)e);
        }
    }
}

