/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.writer;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.spark.shuffle.writer.AddBlockEvent;
import org.apache.uniffle.client.api.ShuffleWriteClient;
import org.apache.uniffle.client.response.SendShuffleDataResult;
import org.apache.uniffle.com.google.common.collect.Queues;
import org.apache.uniffle.com.google.common.collect.Sets;
import org.apache.uniffle.common.ShuffleBlockInfo;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataPusher
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataPusher.class);
    private final ExecutorService executorService;
    private final ShuffleWriteClient shuffleWriteClient;
    private final Map<String, Set<Long>> taskToSuccessBlockIds;
    private final Map<String, Set<Long>> taskToFailedBlockIds;
    private String rssAppId;
    private final Set<String> failedTaskIds;

    public DataPusher(ShuffleWriteClient shuffleWriteClient, Map<String, Set<Long>> taskToSuccessBlockIds, Map<String, Set<Long>> taskToFailedBlockIds, Set<String> failedTaskIds, int threadPoolSize, int threadKeepAliveTime) {
        this.shuffleWriteClient = shuffleWriteClient;
        this.taskToSuccessBlockIds = taskToSuccessBlockIds;
        this.taskToFailedBlockIds = taskToFailedBlockIds;
        this.failedTaskIds = failedTaskIds;
        this.executorService = new ThreadPoolExecutor(threadPoolSize, threadPoolSize * 2, (long)threadKeepAliveTime, TimeUnit.SECONDS, Queues.newLinkedBlockingQueue(Integer.MAX_VALUE), ThreadUtils.getThreadFactory(this.getClass().getName()));
    }

    public CompletableFuture<Long> send(AddBlockEvent event) {
        if (this.rssAppId == null) {
            throw new RssException("RssAppId should be set.");
        }
        return CompletableFuture.supplyAsync(() -> {
            String taskId = event.getTaskId();
            List<ShuffleBlockInfo> shuffleBlockInfoList = event.getShuffleDataInfoList();
            try {
                SendShuffleDataResult result = this.shuffleWriteClient.sendShuffleData(this.rssAppId, shuffleBlockInfoList, () -> !this.isValidTask(taskId));
                this.putBlockId(this.taskToSuccessBlockIds, taskId, result.getSuccessBlockIds());
                this.putBlockId(this.taskToFailedBlockIds, taskId, result.getFailedBlockIds());
            }
            finally {
                List<Runnable> callbackChain = Optional.of(event.getProcessedCallbackChain()).orElse(Collections.EMPTY_LIST);
                for (Runnable runnable : callbackChain) {
                    runnable.run();
                }
            }
            return shuffleBlockInfoList.stream().map(x -> x.getFreeMemory()).reduce((a, b) -> a + b).get();
        }, this.executorService);
    }

    private synchronized void putBlockId(Map<String, Set<Long>> taskToBlockIds, String taskAttemptId, Set<Long> blockIds) {
        if (blockIds == null || blockIds.isEmpty()) {
            return;
        }
        taskToBlockIds.computeIfAbsent(taskAttemptId, x -> Sets.newConcurrentHashSet()).addAll(blockIds);
    }

    public boolean isValidTask(String taskId) {
        return !this.failedTaskIds.contains(taskId);
    }

    public void setRssAppId(String rssAppId) {
        this.rssAppId = rssAppId;
    }

    @Override
    public void close() throws IOException {
        if (this.executorService != null) {
            try {
                ThreadUtils.shutdownThreadPool(this.executorService, 5);
            }
            catch (InterruptedException interruptedException) {
                LOGGER.error("Errors on shutdown thread pool of [{}].", (Object)this.getClass().getSimpleName());
            }
        }
    }
}

