/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.guava.cache;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.uniffle.guava.annotations.GwtCompatible;
import org.apache.uniffle.guava.base.Supplier;
import org.apache.uniffle.guava.cache.ElementTypesAreNonnullByDefault;
import org.apache.uniffle.guava.cache.LongAddable;
import org.apache.uniffle.guava.cache.LongAdder;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class LongAddables {
    private static final Supplier<LongAddable> SUPPLIER;

    LongAddables() {
    }

    public static LongAddable create() {
        return SUPPLIER.get();
    }

    static {
        Supplier<LongAddable> supplier;
        try {
            new LongAdder();
            supplier = new Supplier<LongAddable>(){

                @Override
                public LongAddable get() {
                    return new LongAdder();
                }
            };
        }
        catch (Throwable t) {
            supplier = new Supplier<LongAddable>(){

                @Override
                public LongAddable get() {
                    return new PureJavaLongAddable();
                }
            };
        }
        SUPPLIER = supplier;
    }

    private static final class PureJavaLongAddable
    extends AtomicLong
    implements LongAddable {
        private PureJavaLongAddable() {
        }

        @Override
        public void increment() {
            this.getAndIncrement();
        }

        @Override
        public void add(long x) {
            this.getAndAdd(x);
        }

        @Override
        public long sum() {
            return this.get();
        }
    }
}

