/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.tez.common.GetShuffleServerRequest;
import org.apache.tez.common.GetShuffleServerResponse;
import org.apache.tez.common.RssTezConfig;
import org.apache.tez.common.RssTezUtils;
import org.apache.tez.common.ServicePluginLifecycle;
import org.apache.tez.common.ShuffleAssignmentsInfoWritable;
import org.apache.tez.common.TezRemoteShuffleUmbilicalProtocol;
import org.apache.tez.common.security.JobTokenIdentifier;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.app.security.authorize.RssTezAMPolicyProvider;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.uniffle.client.api.ShuffleWriteClient;
import org.apache.uniffle.com.google.common.collect.Sets;
import org.apache.uniffle.common.PartitionRange;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.common.ShuffleAssignmentsInfo;
import org.apache.uniffle.common.ShuffleDataDistributionType;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.config.RssClientConf;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.util.RetryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezRemoteShuffleManager
implements ServicePluginLifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(TezRemoteShuffleManager.class);
    private InetSocketAddress address;
    protected volatile Server server;
    private String tokenIdentifier;
    private Token<JobTokenIdentifier> sessionToken;
    private Configuration conf;
    private TezRemoteShuffleUmbilicalProtocolImpl tezRemoteShuffleUmbilical;
    private ShuffleWriteClient rssClient;
    private String appId;
    private UserGroupInformation requestUgi;
    private RemoteStorageInfo remoteStorage;

    public TezRemoteShuffleManager(String tokenIdentifier, Token<JobTokenIdentifier> sessionToken, Configuration conf, String appId, ShuffleWriteClient rssClient, RemoteStorageInfo remoteStorage) throws IOException {
        this.tokenIdentifier = tokenIdentifier;
        this.sessionToken = sessionToken;
        this.conf = conf;
        this.appId = appId;
        this.rssClient = rssClient;
        this.tezRemoteShuffleUmbilical = new TezRemoteShuffleUmbilicalProtocolImpl();
        this.requestUgi = UserGroupInformation.getCurrentUser();
        this.remoteStorage = remoteStorage;
    }

    public void initialize() throws Exception {
    }

    public void start() throws Exception {
        this.startRpcServer();
    }

    public void shutdown() throws Exception {
        this.unregisterShuffle();
        this.server.stop();
    }

    public void unregisterShuffle() {
        if (this.rssClient != null) {
            LOG.info("unregister all shuffle for appid {}", (Object)this.appId);
            this.rssClient.unregisterShuffle(this.appId);
        }
    }

    public boolean unregisterShuffleByDagId(TezDAGID dagId) {
        try {
            Set<Integer> shuffleIds = this.tezRemoteShuffleUmbilical.getShuffleIdToShuffleAssignsInfo().keySet().stream().filter(shuffleId -> dagId.getId() == RssTezUtils.parseDagId(shuffleId)).collect(Collectors.toSet());
            shuffleIds.forEach(shuffleId -> {
                long startTime = System.currentTimeMillis();
                this.rssClient.unregisterShuffle(this.appId, (int)shuffleId);
                this.tezRemoteShuffleUmbilical.removeShuffleInfo((int)shuffleId);
                LOG.info("Unregister shuffle successfully, appId={}, dagId={}, shuffleId={}, cost={}ms", new Object[]{this.appId, dagId, shuffleId, System.currentTimeMillis() - startTime});
            });
        }
        catch (Exception e) {
            LOG.info("Failed to unregister shuffle by dagId: {}", (Object)dagId, (Object)e);
            return false;
        }
        return true;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    private ShuffleAssignmentsInfo getShuffleWorks(final int partitionNum, final int shuffleId) {
        ShuffleAssignmentsInfo shuffleAssignmentsInfo;
        final int requiredAssignmentShuffleServersNum = RssTezUtils.getRequiredShuffleServerNumber(this.conf, 200, partitionNum);
        long retryInterval = this.conf.getLong("tez.rss.client.assignment.retry.interval", 65000L);
        int retryTimes = this.conf.getInt("tez.rss.client.assignment.retry.times", 3);
        final HashSet<String> assignmentTags = new HashSet<String>();
        String rawTags = this.conf.get("tez.rss.client.assignment.tags", "");
        if (StringUtils.isNotEmpty((CharSequence)rawTags)) {
            rawTags = rawTags.trim();
            assignmentTags.addAll(Arrays.asList(rawTags.split(",")));
        }
        assignmentTags.add("ss_v4");
        try {
            shuffleAssignmentsInfo = RetryUtils.retry(() -> (ShuffleAssignmentsInfo)this.requestUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ShuffleAssignmentsInfo>(){

                @Override
                public ShuffleAssignmentsInfo run() throws Exception {
                    ShuffleAssignmentsInfo shuffleAssignments = TezRemoteShuffleManager.this.rssClient.getShuffleAssignments(TezRemoteShuffleManager.this.appId, shuffleId, partitionNum, 1, Sets.newHashSet(assignmentTags), requiredAssignmentShuffleServersNum, -1);
                    Map<ShuffleServerInfo, List<PartitionRange>> serverToPartitionRanges = shuffleAssignments.getServerToPartitionRanges();
                    if (serverToPartitionRanges == null || serverToPartitionRanges.isEmpty()) {
                        return null;
                    }
                    LOG.info("Start to register shuffle");
                    long start = System.currentTimeMillis();
                    serverToPartitionRanges.entrySet().forEach(entry -> TezRemoteShuffleManager.this.rssClient.registerShuffle((ShuffleServerInfo)entry.getKey(), TezRemoteShuffleManager.this.appId, shuffleId, (List)entry.getValue(), TezRemoteShuffleManager.this.remoteStorage, ShuffleDataDistributionType.NORMAL, RssTezConfig.toRssConf(TezRemoteShuffleManager.this.conf).get(RssClientConf.MAX_CONCURRENCY_PER_PARTITION_TO_WRITE)));
                    LOG.info("Finish register shuffle with " + (System.currentTimeMillis() - start) + " ms");
                    return shuffleAssignments;
                }
            }), retryInterval, retryTimes);
        }
        catch (Throwable throwable) {
            LOG.error("registerShuffle failed!", throwable);
            throw new RssException("registerShuffle failed!", throwable);
        }
        return shuffleAssignmentsInfo;
    }

    protected void startRpcServer() {
        try {
            Integer rssAmRpcBindPort;
            String rssAmRpcBindAddress;
            if (this.conf.getBoolean("tez.rss.am.shuffle.manager.debug", false)) {
                rssAmRpcBindAddress = this.conf.get("tez.rss.am.shuffle.manager.address", "0.0.0.0");
                rssAmRpcBindPort = this.conf.getInt("tez.rss.am.shuffle.manager.port", 0);
            } else {
                rssAmRpcBindAddress = "0.0.0.0";
                rssAmRpcBindPort = 0;
            }
            JobTokenSecretManager jobTokenSecretManager = new JobTokenSecretManager();
            jobTokenSecretManager.addTokenForJob(this.tokenIdentifier, this.sessionToken);
            this.server = new RPC.Builder(this.conf).setProtocol(TezRemoteShuffleUmbilicalProtocol.class).setBindAddress(rssAmRpcBindAddress).setPort(rssAmRpcBindPort.intValue()).setInstance((Object)this.tezRemoteShuffleUmbilical).setNumHandlers(this.conf.getInt("tez.am.task.listener.thread-count", 30)).setPortRangeConfig("tez.am.task.am.port-range").setSecretManager((SecretManager)jobTokenSecretManager).build();
            if (this.conf.getBoolean("hadoop.security.authorization", false)) {
                this.refreshServiceAcls(this.conf, new RssTezAMPolicyProvider());
            }
            this.server.start();
            InetSocketAddress serverBindAddress = NetUtils.getConnectAddress((Server)this.server);
            this.address = NetUtils.createSocketAddrForHost((String)serverBindAddress.getAddress().getCanonicalHostName(), (int)serverBindAddress.getPort());
            LOG.info("Instantiated TezRemoteShuffleManager RPC at " + this.address);
        }
        catch (IOException e) {
            throw new TezUncheckedException((Throwable)e);
        }
    }

    private void refreshServiceAcls(Configuration configuration, PolicyProvider policyProvider) {
        this.server.refreshServiceAcl(configuration, policyProvider);
    }

    private class TezRemoteShuffleUmbilicalProtocolImpl
    implements TezRemoteShuffleUmbilicalProtocol {
        private Map<Integer, ShuffleAssignmentsInfo> shuffleIdToShuffleAssignsInfo = new ConcurrentHashMap<Integer, ShuffleAssignmentsInfo>();

        private TezRemoteShuffleUmbilicalProtocolImpl() {
        }

        public long getProtocolVersion(String s, long l) throws IOException {
            return 31L;
        }

        public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHash) throws IOException {
            return ProtocolSignature.getProtocolSignature((VersionedProtocol)this, (String)protocol, (long)clientVersion, (int)clientMethodsHash);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GetShuffleServerResponse getShuffleAssignments(GetShuffleServerRequest request) throws IOException, TezException {
            GetShuffleServerResponse response = new GetShuffleServerResponse();
            if (request == null) {
                LOG.error("getShuffleAssignments with request is null");
                response.setStatus(-1);
                response.setRetMsg("GetShuffleServerRequest is null");
                return response;
            }
            LOG.info("getShuffleAssignments with request = " + request);
            int shuffleId = request.getShuffleId();
            try {
                Class<TezRemoteShuffleUmbilicalProtocolImpl> clazz = TezRemoteShuffleUmbilicalProtocolImpl.class;
                synchronized (TezRemoteShuffleUmbilicalProtocolImpl.class) {
                    ShuffleAssignmentsInfo shuffleAssignmentsInfo = this.shuffleIdToShuffleAssignsInfo.containsKey(shuffleId) ? this.shuffleIdToShuffleAssignsInfo.get(shuffleId) : TezRemoteShuffleManager.this.getShuffleWorks(request.getPartitionNum(), shuffleId);
                    if (shuffleAssignmentsInfo == null) {
                        response.setStatus(-1);
                        response.setRetMsg("shuffleAssignmentsInfo is null");
                    } else {
                        response.setStatus(0);
                        response.setRetMsg("");
                        response.setShuffleAssignmentsInfoWritable(new ShuffleAssignmentsInfoWritable(shuffleAssignmentsInfo));
                        this.shuffleIdToShuffleAssignsInfo.put(shuffleId, shuffleAssignmentsInfo);
                    }
                    // ** MonitorExit[var5_4] (shouldn't be in output)
                }
            }
            catch (Exception rssException) {
                response.setStatus(-2);
                response.setRetMsg(rssException.getMessage());
            }
            {
                return response;
            }
        }

        Map<Integer, ShuffleAssignmentsInfo> getShuffleIdToShuffleAssignsInfo() {
            return this.shuffleIdToShuffleAssignsInfo;
        }

        void removeShuffleInfo(int shuffleId) {
            this.shuffleIdToShuffleAssignsInfo.remove(shuffleId);
        }
    }
}

