/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.netty.protocol;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import org.apache.uniffle.common.netty.DecodeException;
import org.apache.uniffle.common.netty.EncodeException;
import org.apache.uniffle.common.netty.protocol.Message;
import org.apache.uniffle.common.netty.protocol.RequestMessage;
import org.apache.uniffle.common.util.ByteBufUtils;
import org.apache.uniffle.common.util.RssUtils;
import org.roaringbitmap.longlong.Roaring64NavigableMap;

public class GetMemoryShuffleDataRequest
extends RequestMessage {
    private String appId;
    private int shuffleId;
    private int partitionId;
    private long lastBlockId;
    private int readBufferSize;
    private long timestamp;
    private Roaring64NavigableMap expectedTaskIdsBitmap;

    public GetMemoryShuffleDataRequest(long requestId, String appId, int shuffleId, int partitionId, long lastBlockId, int readBufferSize, long timestamp, Roaring64NavigableMap expectedTaskIdsBitmap) {
        super(requestId);
        this.appId = appId;
        this.shuffleId = shuffleId;
        this.partitionId = partitionId;
        this.lastBlockId = lastBlockId;
        this.readBufferSize = readBufferSize;
        this.timestamp = timestamp;
        this.expectedTaskIdsBitmap = expectedTaskIdsBitmap;
    }

    @Override
    public Message.Type type() {
        return Message.Type.GET_MEMORY_SHUFFLE_DATA_REQUEST;
    }

    @Override
    public int encodedLength() {
        return (int)((long)(8 + ByteBufUtils.encodedLength(this.appId) + 16 + 16) + this.expectedTaskIdsBitmap.serializedSizeInBytes());
    }

    @Override
    public void encode(ByteBuf buf) throws EncodeException {
        buf.writeLong(this.getRequestId());
        ByteBufUtils.writeLengthAndString(buf, this.appId);
        buf.writeInt(this.shuffleId);
        buf.writeInt(this.partitionId);
        buf.writeLong(this.lastBlockId);
        buf.writeInt(this.readBufferSize);
        buf.writeLong(this.timestamp);
        buf.writeInt((int)this.expectedTaskIdsBitmap.serializedSizeInBytes());
        try {
            buf.writeBytes(RssUtils.serializeBitMap(this.expectedTaskIdsBitmap));
        }
        catch (IOException ioException) {
            throw new EncodeException("serializeBitMap failed while encode GetMemoryShuffleDataRequest!", ioException);
        }
    }

    public static GetMemoryShuffleDataRequest decode(ByteBuf byteBuf) throws DecodeException {
        Roaring64NavigableMap expectedTaskIdsBitmap;
        long requestId = byteBuf.readLong();
        String appId = ByteBufUtils.readLengthAndString(byteBuf);
        int shuffleId = byteBuf.readInt();
        int partitionId = byteBuf.readInt();
        long lastBlockId = byteBuf.readLong();
        int readBufferSize = byteBuf.readInt();
        long timestamp = byteBuf.readLong();
        byte[] bytes = ByteBufUtils.readByteArray(byteBuf);
        try {
            expectedTaskIdsBitmap = RssUtils.deserializeBitMap(bytes);
        }
        catch (IOException ioException) {
            throw new DecodeException("serializeBitMap failed while decode GetMemoryShuffleDataRequest!", ioException);
        }
        return new GetMemoryShuffleDataRequest(requestId, appId, shuffleId, partitionId, lastBlockId, readBufferSize, timestamp, expectedTaskIdsBitmap);
    }

    public String getAppId() {
        return this.appId;
    }

    public int getShuffleId() {
        return this.shuffleId;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public long getLastBlockId() {
        return this.lastBlockId;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Roaring64NavigableMap getExpectedTaskIdsBitmap() {
        return this.expectedTaskIdsBitmap;
    }
}

