/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.handler.impl;

import java.util.List;
import org.apache.uniffle.client.api.ShuffleServerClient;
import org.apache.uniffle.client.request.RssGetInMemoryShuffleDataRequest;
import org.apache.uniffle.client.response.RssGetInMemoryShuffleDataResponse;
import org.apache.uniffle.common.BufferSegment;
import org.apache.uniffle.common.ShuffleDataResult;
import org.apache.uniffle.common.exception.RssFetchFailedException;
import org.apache.uniffle.storage.handler.impl.AbstractClientReadHandler;
import org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryClientReadHandler
extends AbstractClientReadHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryClientReadHandler.class);
    private long lastBlockId = -1L;
    private ShuffleServerClient shuffleServerClient;
    private Roaring64NavigableMap expectTaskIds;

    public MemoryClientReadHandler(String appId, int shuffleId, int partitionId, int readBufferSize, ShuffleServerClient shuffleServerClient, Roaring64NavigableMap expectTaskIds) {
        this.appId = appId;
        this.shuffleId = shuffleId;
        this.partitionId = partitionId;
        this.readBufferSize = readBufferSize;
        this.shuffleServerClient = shuffleServerClient;
        this.expectTaskIds = expectTaskIds;
    }

    @Override
    public ShuffleDataResult readShuffleData() {
        ShuffleDataResult result = null;
        RssGetInMemoryShuffleDataRequest request = new RssGetInMemoryShuffleDataRequest(this.appId, this.shuffleId, this.partitionId, this.lastBlockId, this.readBufferSize, this.expectTaskIds);
        try {
            RssGetInMemoryShuffleDataResponse response = this.shuffleServerClient.getInMemoryShuffleData(request);
            result = new ShuffleDataResult(response.getData(), response.getBufferSegments());
        }
        catch (RssFetchFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RssFetchFailedException("Failed to read in memory shuffle data with " + this.shuffleServerClient.getClientInfo() + " due to " + e);
        }
        if (!result.isEmpty()) {
            List bufferSegments = result.getBufferSegments();
            this.lastBlockId = ((BufferSegment)bufferSegments.get(bufferSegments.size() - 1)).getBlockId();
        }
        return result;
    }
}

