/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.org.roaringbitmap;

import org.apache.uniffle.org.roaringbitmap.ArrayBatchIterator;
import org.apache.uniffle.org.roaringbitmap.ArrayContainer;
import org.apache.uniffle.org.roaringbitmap.BatchIterator;
import org.apache.uniffle.org.roaringbitmap.BitmapBatchIterator;
import org.apache.uniffle.org.roaringbitmap.BitmapContainer;
import org.apache.uniffle.org.roaringbitmap.Container;
import org.apache.uniffle.org.roaringbitmap.ContainerBatchIterator;
import org.apache.uniffle.org.roaringbitmap.RoaringArray;
import org.apache.uniffle.org.roaringbitmap.RunBatchIterator;
import org.apache.uniffle.org.roaringbitmap.RunContainer;

public final class RoaringBatchIterator
implements BatchIterator {
    private final RoaringArray highLowContainer;
    private int index = 0;
    private int key;
    private ContainerBatchIterator iterator;
    private ArrayBatchIterator arrayBatchIterator = null;
    private BitmapBatchIterator bitmapBatchIterator = null;
    private RunBatchIterator runBatchIterator = null;

    public RoaringBatchIterator(RoaringArray highLowContainer) {
        this.highLowContainer = highLowContainer;
        this.nextIterator();
    }

    @Override
    public int nextBatch(int[] buffer) {
        if (!this.hasNext()) {
            return 0;
        }
        int consumed = 0;
        if (this.iterator.hasNext() && (consumed += this.iterator.next(this.key, buffer)) > 0) {
            return consumed;
        }
        ++this.index;
        this.nextIterator();
        if (null != this.iterator) {
            return this.nextBatch(buffer);
        }
        return consumed;
    }

    @Override
    public boolean hasNext() {
        return null != this.iterator;
    }

    @Override
    public BatchIterator clone() {
        try {
            RoaringBatchIterator it = (RoaringBatchIterator)super.clone();
            if (null != this.iterator) {
                it.iterator = this.iterator.clone();
            }
            return it;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    private void nextIterator() {
        if (null != this.iterator) {
            this.iterator.releaseContainer();
        }
        if (this.index < this.highLowContainer.size()) {
            Container container = this.highLowContainer.getContainerAtIndex(this.index);
            if (container instanceof ArrayContainer) {
                this.nextIterator((ArrayContainer)container);
            } else if (container instanceof BitmapContainer) {
                this.nextIterator((BitmapContainer)container);
            } else if (container instanceof RunContainer) {
                this.nextIterator((RunContainer)container);
            }
            this.key = this.highLowContainer.getKeyAtIndex(this.index) << 16;
        } else {
            this.iterator = null;
        }
    }

    private void nextIterator(ArrayContainer array) {
        if (null == this.arrayBatchIterator) {
            this.arrayBatchIterator = new ArrayBatchIterator(array);
        } else {
            this.arrayBatchIterator.wrap(array);
        }
        this.iterator = this.arrayBatchIterator;
    }

    private void nextIterator(BitmapContainer bitmap) {
        if (null == this.bitmapBatchIterator) {
            this.bitmapBatchIterator = new BitmapBatchIterator(bitmap);
        } else {
            this.bitmapBatchIterator.wrap(bitmap);
        }
        this.iterator = this.bitmapBatchIterator;
    }

    private void nextIterator(RunContainer run) {
        if (null == this.runBatchIterator) {
            this.runBatchIterator = new RunBatchIterator(run);
        } else {
            this.runBatchIterator.wrap(run);
        }
        this.iterator = this.runBatchIterator;
    }
}

