/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common;

import java.util.Objects;

public class PartitionRange
implements Comparable<PartitionRange> {
    private final int start;
    private final int end;

    public PartitionRange(int start, int end) {
        if (start > end || start < 0) {
            throw new IllegalArgumentException("Illegal partition range [start, end]");
        }
        this.start = start;
        this.end = end;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getPartitionNum() {
        return this.end - this.start + 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionRange that = (PartitionRange)o;
        return this.start == that.start && this.end == that.end;
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }

    public String toString() {
        return "PartitionRange[" + this.start + ", " + this.end + ']';
    }

    @Override
    public int compareTo(PartitionRange o) {
        return this.getStart() - o.getStart();
    }
}

