/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.api;

import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;

public class RateLimitException
extends FaultToleranceException {
    private final long retryAfterMillis;

    public RateLimitException() {
        this.retryAfterMillis = -1L;
    }

    public RateLimitException(long retryAfterMillis) {
        this.retryAfterMillis = retryAfterMillis;
    }

    public RateLimitException(Throwable t) {
        super(t);
        this.retryAfterMillis = -1L;
    }

    public RateLimitException(long retryAfterMillis, Throwable t) {
        super(t);
        this.retryAfterMillis = retryAfterMillis;
    }

    public RateLimitException(String message) {
        super(message);
        this.retryAfterMillis = -1L;
    }

    public RateLimitException(long retryAfterMillis, String message) {
        super(message);
        this.retryAfterMillis = retryAfterMillis;
    }

    public RateLimitException(String message, Throwable t) {
        super(message, t);
        this.retryAfterMillis = -1L;
    }

    public RateLimitException(long retryAfterMillis, String message, Throwable t) {
        super(message, t);
        this.retryAfterMillis = retryAfterMillis;
    }

    public long getRetryAfterMillis() {
        return this.retryAfterMillis;
    }
}

