/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.component;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.Map;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.base.HtmlRenderer;
import org.apache.myfaces.renderkit.html.util.ClientBehaviorRendererUtils;
import org.apache.myfaces.renderkit.html.util.CommonHtmlAttributesUtil;
import org.apache.myfaces.renderkit.html.util.CommonHtmlEventsUtil;
import org.apache.myfaces.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.renderkit.html.util.ResourceUtils;
import org.apache.myfaces.view.facelets.LocationAwareFacesException;
import org.apache.myfaces.view.facelets.component.JsfElement;

public class JsfElementRenderer
extends HtmlRenderer {
    public boolean getRendersChildren() {
        return true;
    }

    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        ClientBehaviorRendererUtils.decodeClientBehaviors(context, component);
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String elementName = (String)component.getPassThroughAttributes().get("elementName");
        if (elementName == null) {
            throw new LocationAwareFacesException("jsf:element with clientId" + component.getClientId(facesContext) + " requires 'elementName' passthrough attribute", component);
        }
        JsfElement jsfElement = (JsfElement)component;
        Map behaviors = jsfElement.getClientBehaviors();
        if (behaviors != null && !behaviors.isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, writer);
        }
        writer.startElement(elementName, component);
        if (!behaviors.isEmpty()) {
            HtmlRendererUtils.writeIdAndName(writer, component, facesContext);
        } else {
            HtmlRendererUtils.writeIdIfNecessary(writer, component, facesContext);
        }
        long commonPropertiesMarked = CommonHtmlAttributesUtil.getMarkedAttributes(component);
        if (behaviors.isEmpty()) {
            CommonHtmlAttributesUtil.renderEventProperties(writer, commonPropertiesMarked, component);
            CommonHtmlAttributesUtil.renderFocusBlurEventProperties(writer, commonPropertiesMarked, component);
            CommonHtmlAttributesUtil.renderChangeSelectEventProperties(writer, commonPropertiesMarked, component);
        } else {
            long commonEventsMarked = CommonHtmlEventsUtil.getMarkedEvents(component);
            CommonHtmlEventsUtil.renderBehaviorizedEventHandlers(facesContext, writer, commonPropertiesMarked, commonEventsMarked, component, behaviors);
            CommonHtmlEventsUtil.renderBehaviorizedFieldEventHandlers(facesContext, writer, commonPropertiesMarked, commonEventsMarked, component, component.getClientId(facesContext), behaviors);
        }
        CommonHtmlAttributesUtil.renderStyleProperties(writer, commonPropertiesMarked, component);
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onload", component, "load", behaviors, "onload");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onunload", component, "unload", behaviors, "onunload");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        RendererUtils.renderChildren(facesContext, component);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String elementName = (String)component.getPassThroughAttributes().get("elementName");
        writer.endElement(elementName);
    }

    @Override
    protected boolean isCommonPropertiesOptimizationEnabled(FacesContext facesContext) {
        return true;
    }

    @Override
    protected boolean isCommonEventsOptimizationEnabled(FacesContext facesContext) {
        return true;
    }
}

