/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina.routing;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Route {
    private static final String[] EMPTY_CONTEXT = new String[0];
    private final ThreadLocal<Matcher> matcher = new ThreadLocal();
    private Pattern originPattern;
    private String origin;
    private String destination;

    public Route from(String value) {
        this.origin = value;
        this.originPattern = Pattern.compile(value);
        return this;
    }

    public Route to(String value) {
        this.destination = value;
        return this;
    }

    public String cleanDestination(String prefix) {
        String destination = this.destination;
        Matcher matcher = this.matcher.get();
        if (matcher != null) {
            String[] context = this.currentContext();
            for (int i = 0; i < context.length; ++i) {
                destination = destination.replace("$" + (i + 1), context[i]);
            }
        }
        this.matcher.remove();
        if (prefix == null) {
            return destination;
        }
        return destination.substring(prefix.length());
    }

    public String getOrigin() {
        return this.origin;
    }

    public boolean matches(String uri) {
        Matcher matcher = this.originPattern.matcher(uri);
        boolean ok = matcher.matches();
        if (ok) {
            this.matcher.set(matcher);
        }
        return ok;
    }

    private String[] currentContext() {
        if (this.matcher.get().groupCount() > 0) {
            return this.buildContext(this.matcher.get());
        }
        return EMPTY_CONTEXT;
    }

    private String[] buildContext(Matcher matcher) {
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 1; i < matcher.groupCount() + 1; ++i) {
            values.add(matcher.group(i));
        }
        return values.toArray(new String[values.size()]);
    }

    public String getRawDestination() {
        return this.destination;
    }
}

