/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.session;

import org.apache.catalina.ha.ClusterMessageBase;
import org.apache.catalina.ha.session.SessionMessage;

public class SessionMessageImpl
extends ClusterMessageBase
implements SessionMessage {
    private static final long serialVersionUID = 2L;
    private final int mEvtType;
    private final byte[] mSession;
    private final String mSessionID;
    private final String mContextName;
    private long serializationTimestamp;
    private boolean timestampSet = false;
    private String uniqueId;

    private SessionMessageImpl(String contextName, int eventtype, byte[] session, String sessionID) {
        this.mEvtType = eventtype;
        this.mSession = session;
        this.mSessionID = sessionID;
        this.mContextName = contextName;
        this.uniqueId = sessionID;
    }

    public SessionMessageImpl(String contextName, int eventtype, byte[] session, String sessionID, String uniqueID) {
        this(contextName, eventtype, session, sessionID);
        this.uniqueId = uniqueID;
    }

    @Override
    public int getEventType() {
        return this.mEvtType;
    }

    @Override
    public byte[] getSession() {
        return this.mSession;
    }

    @Override
    public String getSessionID() {
        return this.mSessionID;
    }

    @Override
    public void setTimestamp(long time) {
        if (!this.timestampSet) {
            this.serializationTimestamp = time;
            this.timestampSet = true;
        }
    }

    @Override
    public long getTimestamp() {
        return this.serializationTimestamp;
    }

    @Override
    public String getEventTypeString() {
        return switch (this.mEvtType) {
            case 1 -> "SESSION-MODIFIED";
            case 2 -> "SESSION-EXPIRED";
            case 3 -> "SESSION-ACCESSED";
            case 4 -> "SESSION-GET-ALL";
            case 13 -> "SESSION-DELTA";
            case 12 -> "ALL-SESSION-DATA";
            case 14 -> "SESSION-STATE-TRANSFERRED";
            case 15 -> "SESSION-ID-CHANGED";
            case 16 -> "NO-CONTEXT-MANAGER";
            default -> "UNKNOWN-EVENT-TYPE";
        };
    }

    @Override
    public String getContextName() {
        return this.mContextName;
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    public String toString() {
        return this.getEventTypeString() + "#" + this.getContextName() + "#" + this.getSessionID();
    }
}

