/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.language.translator;

import java.util.function.Function;
import org.apache.tinkerpop.gremlin.language.translator.AnonymizedTranslatorVisitor;
import org.apache.tinkerpop.gremlin.language.translator.DotNetTranslateVisitor;
import org.apache.tinkerpop.gremlin.language.translator.GoTranslateVisitor;
import org.apache.tinkerpop.gremlin.language.translator.GroovyTranslateVisitor;
import org.apache.tinkerpop.gremlin.language.translator.JavaTranslateVisitor;
import org.apache.tinkerpop.gremlin.language.translator.JavascriptTranslateVisitor;
import org.apache.tinkerpop.gremlin.language.translator.PythonTranslateVisitor;
import org.apache.tinkerpop.gremlin.language.translator.TranslateVisitor;

public enum Translator {
    LANGUAGE("Language", TranslateVisitor::new),
    ANONYMIZED("Anonymized", AnonymizedTranslatorVisitor::new),
    DOTNET("DotNet", DotNetTranslateVisitor::new),
    GO("Go", GoTranslateVisitor::new),
    GROOVY("Groovy", GroovyTranslateVisitor::new),
    JAVA("Java", JavaTranslateVisitor::new),
    JAVASCRIPT("Javascript", JavascriptTranslateVisitor::new),
    PYTHON("Python", PythonTranslateVisitor::new);

    private final String name;
    private final Function<String, TranslateVisitor> translateVisitorMaker;

    private Translator(String name, Function<String, TranslateVisitor> translateVisitorMaker) {
        this.name = name;
        this.translateVisitorMaker = translateVisitorMaker;
    }

    public String getName() {
        return this.name;
    }

    public TranslateVisitor getTranslateVisitor(String graphTraversalSourceName) {
        return this.translateVisitorMaker.apply(graphTraversalSourceName);
    }

    public String toString() {
        return "Translator[" + this.name + "]";
    }
}

