/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import java.util.Arrays;
import java.util.zip.Deflater;

@ChannelHandler.Sharable
public class HttpContentCompressionHandler
extends ChannelOutboundHandlerAdapter {
    private static final AttributeKey<Deflater> DEFLATER = AttributeKey.valueOf((String)"deflater");
    private static final int MIN_BUFFER_SIZE = 16;

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        Object out = msg;
        int writeIdx = 0;
        int bytesWritten = 0;
        if (msg instanceof HttpResponse && ((HttpResponse)msg).headers().contains((CharSequence)HttpHeaderNames.CONTENT_ENCODING)) {
            ctx.attr(DEFLATER).set((Object)new Deflater());
        }
        if (msg instanceof HttpContent) {
            ByteBuf chunk = ((HttpContent)msg).content();
            Deflater compressor = (Deflater)ctx.attr(DEFLATER).get();
            if (null == compressor) {
                super.write(ctx, msg, promise);
                return;
            }
            compressor.setInput(ByteBufUtil.getBytes((ByteBuf)chunk));
            if (msg instanceof LastHttpContent) {
                compressor.finish();
            }
            int compressedSizeEstimate = chunk.readableBytes() / 8;
            byte[] outBuf = new byte[Math.max(compressedSizeEstimate, 16)];
            bytesWritten = compressor.deflate(outBuf, writeIdx, outBuf.length, 2);
            while (bytesWritten == outBuf.length - writeIdx) {
                outBuf = Arrays.copyOf(outBuf, outBuf.length * 2);
                bytesWritten = compressor.deflate(outBuf, writeIdx += bytesWritten, outBuf.length - writeIdx, 2);
            }
            out = ((HttpContent)msg).replace(Unpooled.wrappedBuffer((byte[])outBuf).writerIndex(writeIdx += bytesWritten));
            ReferenceCountUtil.release((Object)msg);
            if (out instanceof LastHttpContent) {
                ((Deflater)ctx.attr(DEFLATER).getAndSet(null)).end();
            }
        }
        super.write(ctx, out, promise);
    }
}

