/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.traverser.util;

import java.util.Collection;
import java.util.function.Function;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.TraverserSet;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.Host;

public class IndexedTraverserSet<S, I>
extends TraverserSet<S> {
    private final MultiValuedMap<I, Traverser.Admin<S>> index = new ArrayListValuedHashMap();
    private final Function<S, I> indexingFunction;

    public IndexedTraverserSet(Function<S, I> indexingFunction) {
        this(indexingFunction, null);
    }

    public IndexedTraverserSet(Function<S, I> indexingFunction, Traverser.Admin<S> traverser) {
        super(traverser);
        this.indexingFunction = indexingFunction;
    }

    @Override
    public void clear() {
        this.index.clear();
        super.clear();
    }

    @Override
    public boolean add(Traverser.Admin<S> traverser) {
        boolean newOne = super.add(traverser);
        if (newOne) {
            this.index.put(this.indexingFunction.apply(traverser.get()), traverser);
        }
        return newOne;
    }

    public Collection<Traverser.Admin<S>> get(I k) {
        Collection c = this.index.get(k);
        return c != null && c.isEmpty() ? null : c;
    }

    @Override
    public boolean offer(Traverser.Admin<S> traverser) {
        return this.add(traverser);
    }

    @Override
    public Traverser.Admin<S> remove() {
        Object removed = super.remove();
        this.index.removeMapping(this.indexingFunction.apply(removed.get()), removed);
        return removed;
    }

    @Override
    public boolean remove(Object traverser) {
        if (!(traverser instanceof Traverser.Admin)) {
            throw new IllegalArgumentException("The object to remove must be traverser");
        }
        boolean removed = super.remove(traverser);
        if (removed) {
            this.index.removeMapping(this.indexingFunction.apply(((Traverser.Admin)traverser).get()), traverser);
        }
        return removed;
    }

    public static class VertexIndexedTraverserSet
    extends IndexedTraverserSet<Object, Vertex> {
        public VertexIndexedTraverserSet() {
            super(Host::getHostingVertex);
        }
    }
}

