/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.tapestry5.commons.internal.services.ServiceMessages;
import org.apache.tapestry5.commons.services.PlasticProxyFactory;
import org.apache.tapestry5.commons.services.PropertyAccess;
import org.apache.tapestry5.commons.services.PropertyAdapter;
import org.apache.tapestry5.ioc.services.Builtin;
import org.apache.tapestry5.ioc.services.PropertyShadowBuilder;
import org.apache.tapestry5.plastic.ClassInstantiator;
import org.apache.tapestry5.plastic.Condition;
import org.apache.tapestry5.plastic.InstructionBuilder;
import org.apache.tapestry5.plastic.InstructionBuilderCallback;
import org.apache.tapestry5.plastic.MethodDescription;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticClassTransformer;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.plastic.PlasticMethod;

public class PropertyShadowBuilderImpl
implements PropertyShadowBuilder {
    private final PropertyAccess propertyAccess;
    private final PlasticProxyFactory proxyFactory;
    private static final MethodSignatureUniqueComparator METHOD_COMPARATOR = new MethodSignatureUniqueComparator();

    public PropertyShadowBuilderImpl(@Builtin PlasticProxyFactory proxyFactory, PropertyAccess propertyAccess) {
        this.proxyFactory = proxyFactory;
        this.propertyAccess = propertyAccess;
    }

    @Override
    public <T> T build(final Object source, final String propertyName, final Class<T> propertyType) {
        final Class<?> sourceClass = source.getClass();
        final PropertyAdapter adapter = this.propertyAccess.getAdapter(sourceClass).getPropertyAdapter(propertyName);
        if (adapter == null) {
            throw new RuntimeException(ServiceMessages.noSuchProperty(sourceClass, (String)propertyName));
        }
        if (!adapter.isRead()) {
            throw new RuntimeException(String.format("Class %s does not provide an accessor ('getter') method for property '%s'.", source.getClass().getName(), propertyName));
        }
        if (!propertyType.isAssignableFrom(adapter.getType())) {
            throw new RuntimeException(ServiceMessages.propertyTypeMismatch((String)propertyName, sourceClass, (Class)adapter.getType(), propertyType));
        }
        ClassInstantiator instantiator = this.proxyFactory.createProxy(propertyType, new PlasticClassTransformer(){

            public void transform(PlasticClass plasticClass) {
                final PlasticField sourceField = plasticClass.introduceField(sourceClass, "source").inject(source);
                PlasticMethod delegateMethod = plasticClass.introducePrivateMethod(propertyType.getName(), "readProperty", null, null);
                delegateMethod.changeImplementation(new InstructionBuilderCallback(){

                    public void doBuild(InstructionBuilder builder) {
                        builder.loadThis().getField(sourceField);
                        builder.invoke(sourceClass, propertyType, adapter.getReadMethod().getName(), new Class[0]);
                        builder.dupe().when(Condition.NULL, new InstructionBuilderCallback(){

                            public void doBuild(InstructionBuilder builder) {
                                builder.throwException(NullPointerException.class, String.format("Unable to delegate method invocation to property '%s' of %s, because the property is null.", propertyName, source));
                            }
                        });
                        builder.returnResult();
                    }
                });
                for (Method m : METHOD_COMPARATOR.getUniqueMethods(propertyType)) {
                    MethodDescription description = new MethodDescription(m);
                    if (Modifier.isStatic(description.modifiers)) continue;
                    plasticClass.introduceMethod(description).delegateTo(delegateMethod);
                }
                plasticClass.addToString(String.format("<Shadow: property %s of %s>", propertyName, source));
            }
        });
        return propertyType.cast(instantiator.newInstance());
    }

    private static final class MethodSignatureUniqueComparator
    implements Comparator<Method> {
        private MethodSignatureUniqueComparator() {
        }

        @Override
        public int compare(Method o1, Method o2) {
            int comparison = o1.getName().compareTo(o2.getName());
            if (comparison == 0) {
                comparison = o1.getParameterTypes().length - o2.getParameterTypes().length;
            }
            if (comparison == 0) {
                int count = o1.getParameterTypes().length;
                for (int i = 0; i < count; ++i) {
                    Class<?> p2;
                    Class<?> p1 = o1.getParameterTypes()[i];
                    if (p1.equals(p2 = o2.getParameterTypes()[i])) continue;
                    comparison = p1.getName().compareTo(p2.getName());
                    break;
                }
            }
            return comparison;
        }

        public List<Method> getUniqueMethods(Class interfaceType) {
            ArrayList<Method> unique = new ArrayList<Method>(Arrays.asList(interfaceType.getMethods()));
            Collections.sort(unique, this);
            Method last = null;
            Iterator iterator = unique.iterator();
            while (iterator.hasNext()) {
                Method m = (Method)iterator.next();
                if (last != null && this.compare(m, last) == 0) {
                    iterator.remove();
                }
                last = m;
            }
            return unique;
        }
    }
}

