/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.List;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.http.services.RequestGlobals;
import org.apache.tapestry5.internal.events.EndOfRequestListener;
import org.apache.tapestry5.internal.services.EndOfRequestEventHub;

public class EndOfRequestEventHubImpl
implements EndOfRequestEventHub {
    private final RequestGlobals requestGlobals;
    private final List<EndOfRequestListener> listeners = CollectionFactory.newThreadSafeList();

    public EndOfRequestEventHubImpl(RequestGlobals requestGlobals) {
        this.requestGlobals = requestGlobals;
    }

    @Override
    public void addEndOfRequestListener(EndOfRequestListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeEndOfRequestListener(EndOfRequestListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void fire() {
        if (this.requestGlobals.getRequest() == null) {
            return;
        }
        for (EndOfRequestListener l : this.listeners) {
            l.requestDidComplete();
        }
    }
}

