/*
 * Decompiled with CFR 0.152.
 */
package jcuda.driver;

import jcuda.driver.CUarray;
import jcuda.driver.CUarray_format;
import jcuda.driver.CUdeviceptr;
import jcuda.driver.CUmipmappedArray;

public class CUDA_RESOURCE_DESC {
    public int resType;
    public int flags;
    public CUarray array_hArray = new CUarray();
    public CUmipmappedArray mipmap_hMipmappedArray;
    public CUdeviceptr linear_devPtr = new CUdeviceptr();
    public int linear_format;
    public int linear_numChannels;
    public long linear_sizeInBytes;
    public CUdeviceptr pitch2D_devPtr = new CUdeviceptr();
    public int pitch2D_format;
    public int pitch2D_numChannels;
    public long pitch2D_width;
    public long pitch2D_height;
    public long pitch2D_pitchInBytes;

    public String toString() {
        return "CUDA_RESOURCE_DESC[" + this.createString(",") + "]";
    }

    public String toFormattedString() {
        return "CUDA resource descriptor:\n    " + this.createString("\n    ");
    }

    private String createString(String f) {
        StringBuilder sb = new StringBuilder();
        switch (this.resType) {
            case 0: {
                sb.append("hArray=" + this.array_hArray + f);
                break;
            }
            case 1: {
                sb.append("hMipmappedArray=" + this.mipmap_hMipmappedArray + f);
                break;
            }
            case 2: {
                sb.append("devPtr=" + this.linear_devPtr + f);
                sb.append("format=" + CUarray_format.stringFor(this.linear_format) + f);
                sb.append("numChannels=" + this.linear_numChannels + f);
                sb.append("sizeInBytes=" + this.linear_sizeInBytes + f);
                break;
            }
            case 3: {
                sb.append("devPtr=" + this.pitch2D_devPtr + f);
                sb.append("format=" + CUarray_format.stringFor(this.pitch2D_format) + f);
                sb.append("numChannels=" + this.pitch2D_numChannels + f);
                sb.append("width=" + this.pitch2D_width + f);
                sb.append("height=" + this.pitch2D_height + f);
                sb.append("pitchInBytes=" + this.pitch2D_pitchInBytes + f);
                break;
            }
            default: {
                sb.append("INVALID");
            }
        }
        return sb.toString();
    }
}

