/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.io.FrameReaderJSONL;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.util.CommonThreadPool;

public class FrameReaderJSONLParallel
extends FrameReaderJSONL {
    /*
     * WARNING - void declaration
     */
    @Override
    protected void readJSONLFrameFromHDFS(Path path, JobConf jobConf, FileSystem fileSystem, FrameBlock dest, Types.ValueType[] schema, Map<String, Integer> schemaMap) throws IOException {
        int numThreads = OptimizerUtils.getParallelTextReadParallelism();
        TextInputFormat inputFormat = new TextInputFormat();
        inputFormat.configure(jobConf);
        InputSplit[] splits = inputFormat.getSplits(jobConf, numThreads);
        splits = IOUtilFunctions.sortInputSplits(splits);
        ExecutorService pool = CommonThreadPool.get(numThreads);
        try {
            void var16_21;
            ArrayList<IOUtilFunctions.CountRowsTask> countRowsTasks = new ArrayList<IOUtilFunctions.CountRowsTask>();
            for (InputSplit split : splits) {
                countRowsTasks.add(new IOUtilFunctions.CountRowsTask(split, inputFormat, jobConf));
            }
            long offset = 0L;
            ArrayList<Long> offsets = new ArrayList<Long>();
            for (Future future : pool.invokeAll(countRowsTasks)) {
                offsets.add(offset);
                offset += ((Long)future.get()).longValue();
            }
            ArrayList<ReadRowsTask> readRowsTasks = new ArrayList<ReadRowsTask>();
            boolean bl = false;
            while (var16_21 < splits.length) {
                readRowsTasks.add(new ReadRowsTask(splits[var16_21], inputFormat, jobConf, dest, schemaMap, ((Long)offsets.get((int)var16_21)).intValue()));
                ++var16_21;
            }
            CommonThreadPool.invokeAndShutdown(pool, readRowsTasks);
        }
        catch (Exception e) {
            throw new IOException("Failed parallel read of JSONL input.", e);
        }
        finally {
            pool.shutdown();
        }
    }

    private class ReadRowsTask
    implements Callable<Object> {
        private InputSplit _split;
        private TextInputFormat _inputFormat;
        private JobConf _jobConf;
        private FrameBlock _dest;
        Map<String, Integer> _schemaMap;
        private int _offset;

        public ReadRowsTask(InputSplit split, TextInputFormat inputFormat, JobConf jobConf, FrameBlock dest, Map<String, Integer> schemaMap, int offset) {
            this._split = split;
            this._inputFormat = inputFormat;
            this._jobConf = jobConf;
            this._dest = dest;
            this._schemaMap = schemaMap;
            this._offset = offset;
        }

        @Override
        public Object call() throws Exception {
            FrameReaderJSONL.readJSONLFrameFromInputSplit(this._split, (InputFormat<LongWritable, Text>)this._inputFormat, this._jobConf, this._dest.getSchema(), this._schemaMap, this._dest, this._offset);
            return null;
        }
    }
}

