/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.lib;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.CommonThreadPool;

public class CLALibReplace {
    private static final Log LOG = LogFactory.getLog((String)CLALibReplace.class.getName());

    private CLALibReplace() {
    }

    public static MatrixBlock replace(CompressedMatrixBlock in, MatrixBlock out, double pattern, double replacement, int k) {
        try {
            if (Double.isInfinite(pattern)) {
                LOG.info((Object)"Ignoring replace infinite in compression since it does not contain this value");
                return in;
            }
            if (in.isOverlapping()) {
                String message = "replaceOperations " + pattern + " -> " + replacement;
                return in.getUncompressed(message).replaceOperations(out, pattern, replacement);
            }
            return CLALibReplace.replaceNormal(in, out, pattern, replacement, k);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed replace pattern: " + pattern + " replacement: " + replacement, e);
        }
    }

    private static MatrixBlock replaceNormal(CompressedMatrixBlock in, MatrixBlock out, double pattern, double replacement, int k) throws Exception {
        CompressedMatrixBlock ret = new CompressedMatrixBlock(in.getNumRows(), in.getNumColumns());
        List<AColGroup> prev = in.getColGroups();
        int colGroupsLength = prev.size();
        ArrayList<AColGroup> retList = new ArrayList<AColGroup>(colGroupsLength);
        if (k <= 1) {
            CLALibReplace.replaceSingleThread(pattern, replacement, prev, colGroupsLength, retList);
        } else {
            CLALibReplace.replaceMultiThread(pattern, replacement, k, prev, colGroupsLength, retList);
        }
        ret.allocateColGroupList(retList);
        if (replacement == 0.0) {
            ret.recomputeNonZeros();
        } else if (pattern == 0.0) {
            ret.setNonZeros((long)in.getNumRows() * (long)in.getNumColumns());
        } else {
            ret.setNonZeros(in.getNonZeros());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void replaceMultiThread(double pattern, double replacement, int k, List<AColGroup> prev, int colGroupsLength, List<AColGroup> retList) throws InterruptedException, ExecutionException {
        ExecutorService pool = CommonThreadPool.get(k);
        try {
            ArrayList<Future<AColGroup>> tasks = new ArrayList<Future<AColGroup>>(colGroupsLength);
            int i = 0;
            while (i < colGroupsLength) {
                int j = i++;
                tasks.add(pool.submit(() -> ((AColGroup)prev.get(j)).replace(pattern, replacement)));
            }
            for (i = 0; i < colGroupsLength; ++i) {
                retList.add((AColGroup)((Future)tasks.get(i)).get());
            }
        }
        finally {
            pool.shutdown();
        }
    }

    private static void replaceSingleThread(double pattern, double replacement, List<AColGroup> prev, int colGroupsLength, List<AColGroup> retList) {
        for (int i = 0; i < colGroupsLength; ++i) {
            retList.add(prev.get(i).replace(pattern, replacement));
        }
    }
}

