/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.nodelabels.store.op;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.nodelabels.CommonNodeLabelsManager;
import org.apache.hadoop.yarn.nodelabels.store.op.FSNodeStoreLogOp;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerServiceProtos;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReplaceLabelsOnNodeRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.AddToClusterNodeLabelsRequestPBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.ReplaceLabelsOnNodeRequestPBImpl;

public class NodeLabelMirrorOp
extends FSNodeStoreLogOp<CommonNodeLabelsManager> {
    @Override
    public void write(OutputStream os, CommonNodeLabelsManager mgr) throws IOException {
        ((AddToClusterNodeLabelsRequestPBImpl)AddToClusterNodeLabelsRequestPBImpl.newInstance(mgr.getClusterNodeLabels())).getProto().writeDelimitedTo(os);
        if (mgr.isCentralizedConfiguration()) {
            ((ReplaceLabelsOnNodeRequestPBImpl)ReplaceLabelsOnNodeRequest.newInstance(mgr.getNodeLabels())).getProto().writeDelimitedTo(os);
        }
    }

    @Override
    public void recover(InputStream is, CommonNodeLabelsManager mgr) throws IOException {
        List<NodeLabel> labels = new AddToClusterNodeLabelsRequestPBImpl(YarnServerResourceManagerServiceProtos.AddToClusterNodeLabelsRequestProto.parseDelimitedFrom((InputStream)is)).getNodeLabels();
        mgr.addToCluserNodeLabels(labels);
        if (mgr.isCentralizedConfiguration()) {
            Map<NodeId, Set<String>> nodeToLabels = new ReplaceLabelsOnNodeRequestPBImpl(YarnServerResourceManagerServiceProtos.ReplaceLabelsOnNodeRequestProto.parseDelimitedFrom((InputStream)is)).getNodeToLabels();
            mgr.replaceLabelsOnNode(nodeToLabels);
        }
    }

    @Override
    public int getOpCode() {
        return -1;
    }
}

