/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.iogen.template;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.io.FrameReader;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.iogen.CustomProperties;
import org.apache.sysds.runtime.iogen.RowIndexStructure;
import org.apache.sysds.runtime.iogen.template.TemplateUtil;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.util.CommonThreadPool;
import org.apache.sysds.runtime.util.InputStreamInputFormat;

public abstract class FrameGenerateReaderParallel
extends FrameReader {
    protected CustomProperties _props;
    protected int _numThreads = OptimizerUtils.getParallelTextReadParallelism();
    protected JobConf job;
    protected TemplateUtil.SplitOffsetInfos _offsets;
    protected int _rLen;
    protected int _cLen;

    public FrameGenerateReaderParallel(CustomProperties _props) {
        this._props = _props;
    }

    @Override
    public FrameBlock readFrameFromHDFS(String fname, Types.ValueType[] schema, String[] names, long rlen, long clen) throws IOException, DMLRuntimeException {
        this.job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)this.job);
        FileInputFormat.addInputPath((JobConf)this.job, (Path)path);
        TextInputFormat informat = new TextInputFormat();
        informat.configure(this.job);
        InputSplit[] splits = informat.getSplits(this.job, this._numThreads);
        splits = IOUtilFunctions.sortInputSplits(splits);
        FrameGenerateReaderParallel.checkValidInputFile(fs, path);
        FrameBlock ret = this.computeSizeAndCreateOutputFrameBlock(schema, names, splits, path, rlen, clen);
        this.readFrameFromHDFS(splits, path, this.job, ret);
        return ret;
    }

    private FrameBlock computeSizeAndCreateOutputFrameBlock(Types.ValueType[] schema, String[] names, InputSplit[] splits, Path path, long rlen, long clen) throws IOException, DMLRuntimeException {
        this._rLen = 0;
        this._cLen = this._props.getNcols();
        Types.ValueType[] lschema = FrameGenerateReaderParallel.createOutputSchema(schema, this._cLen);
        String[] lnames = FrameGenerateReaderParallel.createOutputNames(names, this._cLen);
        FileInputFormat.addInputPath((JobConf)this.job, (Path)path);
        TextInputFormat informat = new TextInputFormat();
        informat.configure(this.job);
        ExecutorService pool = CommonThreadPool.get(this._numThreads);
        try {
            ArrayList<Callable<Long>> tasks;
            if (this._props.getRowIndexStructure().getProperties() == RowIndexStructure.IndexProperties.Identity) {
                tasks = new ArrayList<Callable<Long>>();
                for (InputSplit split : splits) {
                    tasks.add(new IOUtilFunctions.CountRowsTask(split, informat, this.job, false));
                }
                this._offsets = new TemplateUtil.SplitOffsetInfos(tasks.size());
                int i = 0;
                for (Future rc : pool.invokeAll(tasks)) {
                    int lnrow = (int)((Long)rc.get()).longValue();
                    this._offsets.setOffsetPerSplit(i, this._rLen);
                    this._offsets.setLenghtPerSplit(i, lnrow);
                    this._rLen += lnrow;
                    ++i;
                }
            }
            if (this._props.getRowIndexStructure().getProperties() == RowIndexStructure.IndexProperties.CellWiseExist || this._props.getRowIndexStructure().getProperties() == RowIndexStructure.IndexProperties.RowWiseExist) {
                tasks = new ArrayList();
                for (InputSplit split : splits) {
                    tasks.add(new IOUtilFunctions.CountRowsTask(split, informat, this.job, false));
                }
                this._offsets = new TemplateUtil.SplitOffsetInfos(tasks.size());
                int i = 0;
                for (Future rc : pool.invokeAll(tasks)) {
                    int lnrow = (int)((Long)rc.get()).longValue();
                    this._offsets.setOffsetPerSplit(i, this._rLen);
                    this._offsets.setLenghtPerSplit(i, lnrow);
                    ++i;
                }
            } else if (this._props.getRowIndexStructure().getProperties() == RowIndexStructure.IndexProperties.SeqScatter) {
                this._offsets = new TemplateUtil.SplitOffsetInfos(splits.length);
                for (int i = 0; i < splits.length; ++i) {
                    TemplateUtil.SplitInfo splitInfo = new TemplateUtil.SplitInfo();
                    this._offsets.setSeqOffsetPerSplit(i, splitInfo);
                    this._offsets.setOffsetPerSplit(i, 0);
                }
                tasks = new ArrayList();
                int splitIndex = 0;
                for (InputSplit split : splits) {
                    Integer nextOffset = splitIndex + 1 == splits.length ? null : Integer.valueOf(splitIndex + 1);
                    tasks.add(new CountSeqScatteredRowsTask(this._offsets, splitIndex, nextOffset, split, informat, this.job, this._props.getRowIndexStructure().getSeqBeginString(), this._props.getRowIndexStructure().getSeqEndString()));
                    ++splitIndex;
                }
                int i = 0;
                for (Future rc : pool.invokeAll(tasks)) {
                    Integer nrows = (Integer)rc.get();
                    this._offsets.setOffsetPerSplit(i, this._rLen);
                    this._rLen += nrows.intValue();
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new IOException("Thread pool Error " + e.getMessage(), e);
        }
        finally {
            pool.shutdown();
        }
        if (rlen != -1L && (long)this._rLen != rlen) {
            String msg = "Read frame dimensions differ from meta data: [" + this._rLen + "x" + this._cLen + "] vs. [" + rlen + "x" + clen + "].";
            if (rlen < (long)this._rLen || clen < (long)this._cLen) {
                throw new DMLRuntimeException(msg);
            }
            LOG.warn((Object)msg);
            this._rLen = (int)rlen;
            this._cLen = (int)clen;
        }
        FrameBlock ret = FrameGenerateReaderParallel.createOutputFrameBlock(lschema, lnames, this._rLen);
        return ret;
    }

    @Override
    public FrameBlock readFrameFromInputStream(InputStream is, Types.ValueType[] schema, String[] names, long rlen, long clen) throws IOException, DMLRuntimeException {
        InputStreamInputFormat informat = new InputStreamInputFormat(is);
        InputSplit[] splits = informat.getSplits(null, 1);
        FrameBlock ret = this.computeSizeAndCreateOutputFrameBlock(schema, names, splits, null, rlen, clen);
        return ret;
    }

    protected void readFrameFromHDFS(InputSplit[] splits, Path path, JobConf job, FrameBlock dest) throws IOException {
        FileInputFormat.addInputPath((JobConf)job, (Path)path);
        TextInputFormat informat = new TextInputFormat();
        informat.configure(job);
        ExecutorService pool = CommonThreadPool.get(this._numThreads);
        try {
            ArrayList<ReadTask> tasks = new ArrayList<ReadTask>();
            int splitCount = 0;
            for (InputSplit split : splits) {
                tasks.add(new ReadTask(split, informat, dest, splitCount++));
            }
            for (Future future : pool.invokeAll(tasks)) {
                future.get();
            }
        }
        catch (Exception e) {
            throw new IOException("Threadpool issue, while parallel read.", e);
        }
        finally {
            pool.shutdown();
        }
    }

    protected abstract int readFrameFromHDFS(RecordReader<LongWritable, Text> var1, LongWritable var2, Text var3, FrameBlock var4, int var5, TemplateUtil.SplitInfo var6) throws IOException;

    private static class CountSeqScatteredRowsTask
    implements Callable<Integer> {
        private final TemplateUtil.SplitOffsetInfos _offsets;
        private final Integer _curOffset;
        private final Integer _nextOffset;
        private final InputSplit _split;
        private final TextInputFormat _inputFormat;
        private final JobConf _job;
        private final String _beginToken;
        private final String _endToken;

        public CountSeqScatteredRowsTask(TemplateUtil.SplitOffsetInfos offsets, Integer curOffset, Integer nextOffset, InputSplit split, TextInputFormat inputFormat, JobConf job, String beginToken, String endToken) {
            this._offsets = offsets;
            this._curOffset = curOffset;
            this._nextOffset = nextOffset;
            this._inputFormat = inputFormat;
            this._split = split;
            this._job = job;
            this._beginToken = beginToken;
            this._endToken = endToken;
        }

        @Override
        public Integer call() throws Exception {
            int j;
            int i;
            ArrayList<Object> endIndexes;
            int nrows = 0;
            TemplateUtil.SplitInfo splitInfo = this._offsets.getSeqOffsetPerSplit(this._curOffset);
            Pair<ArrayList<Pair<Long, Integer>>, Long> tokenPair = TemplateUtil.getTokenIndexOnMultiLineRecords(this._split, this._inputFormat, this._job, this._endToken);
            ArrayList<Pair<Long, Integer>> beginIndexes = tokenPair.getKey();
            long lastLineIndex = tokenPair.getValue();
            int tokenLength = 0;
            if (!this._beginToken.equals(this._endToken)) {
                endIndexes = TemplateUtil.getTokenIndexOnMultiLineRecords(this._split, this._inputFormat, this._job, this._endToken).getKey();
                tokenLength = this._endToken.length();
                lastLineIndex = -1L;
            } else {
                endIndexes = new ArrayList<Pair<Long, Integer>>();
                for (i = 1; i < beginIndexes.size(); ++i) {
                    endIndexes.add(beginIndexes.get(i));
                }
            }
            i = 0;
            if (endIndexes.size() > 0) {
                if (beginIndexes.get(0).getKey() > (Long)((Pair)endIndexes.get(0)).getKey()) {
                    ++nrows;
                    for (j = 0; j < endIndexes.size() && beginIndexes.get(0).getKey() > (Long)((Pair)endIndexes.get(j)).getKey(); ++j) {
                    }
                } else if (this._curOffset != 0 && this._beginToken.equals(this._endToken)) {
                    ++nrows;
                }
            }
            while (i < beginIndexes.size() && j < endIndexes.size()) {
                Pair<Long, Integer> p1 = beginIndexes.get(i);
                Pair p2 = (Pair)endIndexes.get(j);
                int n = 0;
                while (p1.getKey() < (Long)p2.getKey() || p1.getKey() == p2.getKey() && p1.getValue() < (Integer)p2.getValue()) {
                    ++n;
                    if (++i == beginIndexes.size()) break;
                    p1 = beginIndexes.get(i);
                }
                splitInfo.addIndexAndPosition(beginIndexes.get(i - n).getKey(), (Long)((Pair)endIndexes.get(j += n - 1)).getKey(), beginIndexes.get(i - n).getValue(), (Integer)((Pair)endIndexes.get(j)).getValue() + tokenLength);
                ++j;
                ++nrows;
            }
            if (this._nextOffset != null) {
                if (beginIndexes.size() == 1) {
                    splitInfo.addIndexAndPosition(beginIndexes.get(0).getKey(), beginIndexes.get(0).getKey(), 0, beginIndexes.get(0).getValue());
                    ++nrows;
                }
                RecordReader reader = this._inputFormat.getRecordReader(this._split, this._job, Reporter.NULL);
                LongWritable key = new LongWritable();
                Text value = new Text();
                StringBuilder sb = new StringBuilder();
                for (long ri = 0L; ri < beginIndexes.get(beginIndexes.size() - 1).getKey(); ++ri) {
                    reader.next((Object)key, (Object)value);
                }
                if (reader.next((Object)key, (Object)value)) {
                    String strVar = value.toString();
                    sb.append(strVar.substring(beginIndexes.get(beginIndexes.size() - 1).getValue()));
                    while (reader.next((Object)key, (Object)value)) {
                        sb.append(value.toString());
                    }
                    this._offsets.getSeqOffsetPerSplit(this._nextOffset).setRemainString(sb.toString());
                }
            } else if (lastLineIndex != -1L) {
                splitInfo.addIndexAndPosition((Long)((Pair)endIndexes.get(endIndexes.size() - 1)).getKey(), lastLineIndex, (Integer)((Pair)endIndexes.get(endIndexes.size() - 1)).getValue(), 0);
                ++nrows;
            }
            splitInfo.setNrows(nrows);
            this._offsets.getSeqOffsetPerSplit(this._curOffset).setNrows(nrows);
            this._offsets.setOffsetPerSplit(this._curOffset, nrows);
            return nrows;
        }
    }

    private class ReadTask
    implements Callable<Long> {
        private final InputSplit _split;
        private final TextInputFormat _informat;
        private final FrameBlock _dest;
        private final int _splitCount;

        public ReadTask(InputSplit split, TextInputFormat informat, FrameBlock dest, int splitCount) {
            this._split = split;
            this._informat = informat;
            this._dest = dest;
            this._splitCount = splitCount;
        }

        @Override
        public Long call() throws IOException {
            RecordReader reader = this._informat.getRecordReader(this._split, FrameGenerateReaderParallel.this.job, Reporter.NULL);
            LongWritable key = new LongWritable();
            Text value = new Text();
            int row = FrameGenerateReaderParallel.this._offsets.getOffsetPerSplit(this._splitCount);
            TemplateUtil.SplitInfo _splitInfo = FrameGenerateReaderParallel.this._offsets.getSeqOffsetPerSplit(this._splitCount);
            FrameGenerateReaderParallel.this.readFrameFromHDFS((RecordReader<LongWritable, Text>)reader, key, value, this._dest, row, _splitInfo);
            return 0L;
        }
    }
}

