/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.compress.CompressedMatrixBlockFactory;
import org.apache.sysds.runtime.compress.CompressionStatistics;
import org.apache.sysds.runtime.compress.SingletonLookupHashMap;
import org.apache.sysds.runtime.compress.lib.CLALibBinCompress;
import org.apache.sysds.runtime.compress.workload.WTreeRoot;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.frame.data.lib.FrameLibCompress;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.Operator;

public class CompressionCPInstruction
extends ComputationCPInstruction {
    private static final Log LOG = LogFactory.getLog((String)CompressionCPInstruction.class.getName());
    private final int _singletonLookupID;
    private final int _numThreads;
    protected final List<CPOperand> _outputs;

    private CompressionCPInstruction(Operator op, CPOperand in, CPOperand out, String opcode, String istr, int singletonLookupID, int numThreads) {
        super(CPInstruction.CPType.Compression, op, in, null, null, out, opcode, istr);
        this._outputs = null;
        this._singletonLookupID = singletonLookupID;
        this._numThreads = numThreads;
    }

    private CompressionCPInstruction(Operator op, CPOperand in1, CPOperand in2, List<CPOperand> out, String opcode, String istr, int singletonLookupID, int numThreads) {
        super(CPInstruction.CPType.Compression, op, in1, in2, null, out.get(0), opcode, istr);
        this._outputs = out;
        this._singletonLookupID = singletonLookupID;
        this._numThreads = numThreads;
    }

    public static CompressionCPInstruction parseInstruction(String str) {
        InstructionUtils.checkNumFields(str, 3, 4, 5);
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        if (parts.length == 6) {
            ArrayList<CPOperand> outputs = new ArrayList<CPOperand>();
            outputs.add(new CPOperand(parts[3]));
            outputs.add(new CPOperand(parts[4]));
            int numThreads = Integer.parseInt(parts[5]);
            return new CompressionCPInstruction(null, in1, out, outputs, opcode, str, 0, numThreads);
        }
        if (parts.length == 5) {
            int treeNodeID = Integer.parseInt(parts[3]);
            int numThreads = Integer.parseInt(parts[4]);
            return new CompressionCPInstruction(null, in1, out, opcode, str, treeNodeID, numThreads);
        }
        int numThreads = Integer.parseInt(parts[3]);
        return new CompressionCPInstruction(null, in1, out, opcode, str, 0, numThreads);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        if (this.input2 == null) {
            this.processSimpleCompressInstruction(ec);
        } else {
            this.processCompressByBinInstruction(ec);
        }
    }

    private void processCompressByBinInstruction(ExecutionContext ec) {
        Pair<MatrixBlock, FrameBlock> out;
        MatrixBlock d = ec.getMatrixInput(this.input2.getName());
        int k = OptimizerUtils.getConstrainedNumThreads(-1);
        if (ec.isMatrixObject(this.input1.getName())) {
            MatrixBlock X = ec.getMatrixInput(this.input1.getName());
            out = CLALibBinCompress.binCompress(X, d, k);
            ec.releaseMatrixInput(this.input1.getName());
        } else {
            FrameBlock X = ec.getFrameInput(this.input1.getName());
            out = CLALibBinCompress.binCompress(X, d, k);
            ec.releaseFrameInput(this.input1.getName());
        }
        ec.releaseMatrixInput(this.input2.getName());
        ec.setMatrixOutput(this._outputs.get(0).getName(), (MatrixBlock)out.getKey());
        ec.setFrameOutput(this._outputs.get(1).getName(), (FrameBlock)out.getValue());
    }

    private void processSimpleCompressInstruction(ExecutionContext ec) {
        WTreeRoot root;
        SingletonLookupHashMap m = SingletonLookupHashMap.getMap();
        WTreeRoot wTreeRoot = root = this._singletonLookupID != 0 ? (WTreeRoot)m.get(this._singletonLookupID) : null;
        if (ec.isFrameObject(this.input1.getName())) {
            this.processFrameBlockCompression(ec, ec.getFrameInput(this.input1.getName()), this._numThreads, root);
        } else if (ec.isMatrixObject(this.input1.getName())) {
            this.processMatrixBlockCompression(ec, ec.getMatrixInput(this.input1.getName()), this._numThreads, root);
        } else {
            LOG.warn((Object)"Compression on Scalar should not happen");
            ScalarObject Scalar = ec.getScalarInput(this.input1);
            ec.setScalarOutput(this.output.getName(), Scalar);
        }
    }

    private void processMatrixBlockCompression(ExecutionContext ec, MatrixBlock in, int k, WTreeRoot root) {
        Pair<MatrixBlock, CompressionStatistics> compResult = CompressedMatrixBlockFactory.compress(in, k, root);
        if (LOG.isTraceEnabled()) {
            LOG.trace(compResult.getRight());
        }
        MatrixBlock out = (MatrixBlock)compResult.getLeft();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Compression output class: " + out.getClass().getSimpleName()));
        }
        ec.releaseMatrixInput(this.input1.getName());
        ec.setMatrixOutput(this.output.getName(), out);
    }

    private void processFrameBlockCompression(ExecutionContext ec, FrameBlock in, int k, WTreeRoot root) {
        FrameBlock compResult = FrameLibCompress.compress(in, k, root);
        ec.releaseFrameInput(this.input1.getName());
        ec.setFrameOutput(this.output.getName(), compResult);
    }
}

