/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim;

import java.util.ArrayList;
import java.util.List;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.estim.ComEstSample;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;
import org.apache.sysds.runtime.compress.lib.CLALibCombineGroups;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class ComEstCompressedSample
extends ComEstSample {
    private static boolean loggedWarning = false;

    public ComEstCompressedSample(CompressedMatrixBlock sample, CompressionSettings cs, CompressedMatrixBlock full, int k) {
        super((MatrixBlock)sample, cs, full, k);
    }

    @Override
    protected List<CompressedSizeInfoColGroup> CompressedSizeInfoColGroup(int clen, int k) {
        ArrayList<CompressedSizeInfoColGroup> ret = new ArrayList<CompressedSizeInfoColGroup>();
        int nRow = this._data.getNumRows();
        List<AColGroup> fg = ((CompressedMatrixBlock)this._data).getColGroups();
        List<AColGroup> sg = ((CompressedMatrixBlock)this._sample).getColGroups();
        for (int i = 0; i < fg.size(); ++i) {
            CompressedSizeInfoColGroup r = fg.get(i).getCompressionInfo(nRow);
            r.setMap(sg.get(i).getCompressionInfo(this._sampleSize).getMap());
            ret.add(r);
        }
        return ret;
    }

    @Override
    public CompressedSizeInfoColGroup getColGroupInfo(IColIndex colIndexes, int estimate, int nrUniqueUpperBound) {
        if (!loggedWarning) {
            LOG.warn((Object)("Compressed input cannot fallback to resampling " + colIndexes));
        }
        loggedWarning = true;
        return null;
    }

    @Override
    public CompressedSizeInfoColGroup getDeltaColGroupInfo(IColIndex colIndexes, int estimate, int nrUniqueUpperBound) {
        if (!loggedWarning) {
            LOG.warn((Object)("Compressed input cannot fallback to resampling " + colIndexes));
        }
        return null;
    }

    @Override
    protected int worstCaseUpperBound(IColIndex columns) {
        CompressedMatrixBlock cData = (CompressedMatrixBlock)this._data;
        if (columns.size() == 1) {
            int id = columns.get(0);
            AColGroup g = cData.getColGroupForColumn(id);
            return g.getNumValues();
        }
        List<AColGroup> groups = CLALibCombineGroups.findGroupsInIndex(columns, cData.getColGroups());
        long nVals = 1L;
        for (AColGroup g : groups) {
            nVals *= (long)g.getNumValues();
        }
        return Math.min(this._data.getNumRows(), (int)Math.min(nVals, Integer.MAX_VALUE));
    }
}

