/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.codegen.cplan.java;

import org.apache.sysds.hops.codegen.cplan.CNodeTernary;
import org.apache.sysds.hops.codegen.cplan.CodeTemplate;

public class Ternary
extends CodeTemplate {
    @Override
    public String getTemplate(CNodeTernary.TernaryType type, boolean sparse) {
        switch (type) {
            case PLUS_MULT: {
                return "    double %TMP% = %IN1% + %IN2% * %IN3%;\n";
            }
            case MINUS_MULT: {
                return "    double %TMP% = %IN1% - %IN2% * %IN3%;\n";
            }
            case BIASADD: {
                return "    double %TMP% = %IN1% + getValue(%IN2%, cix/%IN3%);\n";
            }
            case BIASMULT: {
                return "    double %TMP% = %IN1% * getValue(%IN2%, cix/%IN3%);\n";
            }
            case REPLACE: {
                return "    double %TMP% = (%IN1% == %IN2% || (Double.isNaN(%IN1%) && Double.isNaN(%IN2%))) ? %IN3% : %IN1%;\n";
            }
            case REPLACE_NAN: {
                return "    double %TMP% = Double.isNaN(%IN1%) ? %IN3% : %IN1%;\n";
            }
            case IFELSE: {
                return "    double %TMP% = (%IN1% != 0) ? %IN2% : %IN3%;\n";
            }
            case LOOKUP_RC1: {
                return sparse ? "    double %TMP% = getValue(%IN1v%, %IN1i%, ai, alen, %IN3%-1);\n" : "    double %TMP% = getValue(%IN1%, %IN2%, rix, %IN3%-1);\n";
            }
            case LOOKUP_RVECT1: {
                return "    double[] %TMP% = getVector(%IN1%, %IN2%, rix, %IN3%-1);\n";
            }
        }
        throw new RuntimeException("Invalid ternary type: " + this.toString());
    }
}

