/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.gpu.context;

import jcuda.CudaException;
import jcuda.Pointer;
import jcuda.runtime.JCuda;
import jcuda.runtime.cudaError;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.runtime.instructions.gpu.context.GPUMemoryAllocator;

public class UnifiedMemoryAllocator
implements GPUMemoryAllocator {
    private static long maxAvailableMemory = -1L;
    private static double gpuUtilizationFactor = -1.0;

    @Override
    public void allocate(Pointer devPtr, long size) throws CudaException {
        int status = JCuda.cudaMallocManaged((Pointer)devPtr, (long)size, (int)1);
        if (status != 0) {
            throw new CudaException("cudaMallocManaged failed:" + cudaError.stringFor((int)status));
        }
    }

    @Override
    public void free(Pointer devPtr) throws CudaException {
        int status = JCuda.cudaFree((Pointer)devPtr);
        if (status != 0) {
            throw new CudaException("cudaFree failed:" + cudaError.stringFor((int)status));
        }
    }

    @Override
    public boolean canAllocate(long size) {
        return true;
    }

    @Override
    public long getAvailableMemory() {
        if (maxAvailableMemory < 0L || gpuUtilizationFactor != DMLScript.GPU_MEMORY_UTILIZATION_FACTOR) {
            long[] free = new long[]{0L};
            long[] total = new long[]{0L};
            JCuda.cudaMemGetInfo((long[])free, (long[])total);
            maxAvailableMemory = (long)((double)total[0] * DMLScript.GPU_MEMORY_UTILIZATION_FACTOR);
            gpuUtilizationFactor = DMLScript.GPU_MEMORY_UTILIZATION_FACTOR;
        }
        return maxAvailableMemory;
    }
}

