/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.lib;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.CommonThreadPool;
import org.apache.sysds.utils.stats.InfrastructureAnalyzer;

public interface MatrixBlockFromFrame {
    public static final Log LOG = LogFactory.getLog((String)MatrixBlockFromFrame.class.getName());
    public static final int blocksizeIJ = 32;

    public static MatrixBlock convertToMatrixBlock(FrameBlock frame, int k) {
        return MatrixBlockFromFrame.convertToMatrixBlock(frame, null, k);
    }

    public static MatrixBlock convertToMatrixBlock(FrameBlock frame, MatrixBlock ret, int k) {
        try {
            int m = frame.getNumRows();
            int n = frame.getNumColumns();
            ret = MatrixBlockFromFrame.allocateRet(ret, m, n);
            if (k == -1) {
                k = InfrastructureAnalyzer.getLocalParallelism();
            }
            long nnz = 0L;
            nnz = k == 1 ? MatrixBlockFromFrame.convert(frame, ret, n, 0, m) : MatrixBlockFromFrame.convertParallel(frame, ret, m, n, k);
            ret.setNonZeros(nnz);
            ret.examSparsity();
            return ret;
        }
        catch (Exception e) {
            throw new DMLRuntimeException("Failed to convert FrameBlock to MatrixBlock", e);
        }
    }

    private static MatrixBlock allocateRet(MatrixBlock ret, int m, int n) {
        if (ret == null) {
            ret = new MatrixBlock(m, n, false);
        } else if (ret.getNumRows() != m || ret.getNumColumns() != n || ret.isInSparseFormat()) {
            ret.reset(m, n, false);
        }
        if (!ret.isAllocated()) {
            ret.allocateDenseBlock();
        }
        return ret;
    }

    private static long convert(FrameBlock frame, MatrixBlock mb, int n, int rl, int ru) {
        if (mb.getDenseBlock().isContiguous()) {
            return MatrixBlockFromFrame.convertContiguous(frame, mb, n, rl, ru);
        }
        return MatrixBlockFromFrame.convertGeneric(frame, mb, n, rl, ru);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long convertParallel(FrameBlock frame, MatrixBlock mb, int m, int n, int k) throws Exception {
        ExecutorService pool = CommonThreadPool.get(k);
        try {
            ArrayList<Future<Long>> tasks = new ArrayList<Future<Long>>();
            int blkz = Math.max(m / k, 1000);
            for (int i = 0; i < m; i += blkz) {
                int start = i;
                int end = Math.min(i + blkz, m);
                tasks.add(pool.submit(() -> MatrixBlockFromFrame.convert(frame, mb, n, start, end)));
            }
            long nnz = 0L;
            for (Future future : tasks) {
                nnz += ((Long)future.get()).longValue();
            }
            long l = nnz;
            return l;
        }
        finally {
            pool.shutdown();
        }
    }

    private static long convertContiguous(FrameBlock frame, MatrixBlock mb, int n, int rl, int ru) {
        long lnnz = 0L;
        double[] c = mb.getDenseBlockValues();
        for (int bi = rl; bi < ru; bi += 32) {
            for (int bj = 0; bj < n; bj += 32) {
                int bimin = Math.min(bi + 32, ru);
                int bjmin = Math.min(bj + 32, n);
                lnnz = MatrixBlockFromFrame.convertBlockContiguous(frame, n, lnnz, c, bi, bj, bimin, bjmin);
            }
        }
        return lnnz;
    }

    private static long convertBlockContiguous(FrameBlock frame, int n, long lnnz, double[] c, int rl, int cl, int ru, int cu) {
        int i = rl;
        int aix = rl * n;
        while (i < ru) {
            for (int j = cl; j < cu; ++j) {
                double d = frame.getDoubleNaN(i, j);
                c[aix + j] = d;
                lnnz += d != 0.0 ? 1L : 0L;
            }
            ++i;
            aix += n;
        }
        return lnnz;
    }

    private static long convertGeneric(FrameBlock frame, MatrixBlock mb, int n, int rl, int ru) {
        long lnnz = 0L;
        DenseBlock c = mb.getDenseBlock();
        for (int bi = rl; bi < ru; bi += 32) {
            for (int bj = 0; bj < n; bj += 32) {
                int bimin = Math.min(bi + 32, ru);
                int bjmin = Math.min(bj + 32, n);
                lnnz = MatrixBlockFromFrame.convertBlockGeneric(frame, lnnz, c, bi, bj, bimin, bjmin);
            }
        }
        return lnnz;
    }

    private static long convertBlockGeneric(FrameBlock frame, long lnnz, DenseBlock c, int rl, int cl, int ru, int cu) {
        for (int i = rl; i < ru; ++i) {
            double[] cvals = c.values(i);
            int cpos = c.pos(i);
            for (int j = cl; j < cu; ++j) {
                double d = frame.getDoubleNaN(i, j);
                cvals[cpos + j] = d;
                lnnz += d != 0.0 ? 1L : 0L;
            }
        }
        return lnnz;
    }
}

