/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.parfor.opt;

import java.util.HashMap;
import java.util.Map;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.parser.DMLProgram;
import org.apache.sysds.parser.StatementBlock;
import org.apache.sysds.runtime.controlprogram.Program;
import org.apache.sysds.runtime.controlprogram.ProgramBlock;
import org.apache.sysds.runtime.controlprogram.parfor.opt.OptNode;
import org.apache.sysds.runtime.controlprogram.parfor.util.IDSequence;

public class OptTreePlanMapping {
    protected IDSequence _idSeq = new IDSequence();
    protected Map<Long, OptNode> _id_optnode = new HashMap<Long, OptNode>();
    private DMLProgram _prog = null;
    private Program _rtprog = null;
    private Map<Long, Object> _id_hlprog = new HashMap<Long, Object>();
    private Map<Long, Object> _id_rtprog = new HashMap<Long, Object>();

    public OptNode getOptNode(long id) {
        return this._id_optnode.get(id);
    }

    public long getMappedParentID(long id) {
        for (OptNode p : this._id_optnode.values()) {
            if (p.getChilds() == null) continue;
            for (OptNode c2 : p.getChilds()) {
                if (id != c2.getID()) continue;
                return p.getID();
            }
        }
        return -1L;
    }

    public void putRootProgram(DMLProgram prog, Program rtprog) {
        this._prog = prog;
        this._rtprog = rtprog;
    }

    public long putHopMapping(Hop hops, OptNode n) {
        long id = this._idSeq.getNextID();
        this._id_hlprog.put(id, hops);
        this._id_rtprog.put(id, null);
        this._id_optnode.put(id, n);
        n.setID(id);
        return id;
    }

    public long putProgMapping(StatementBlock sb, ProgramBlock pb, OptNode n) {
        long id = this._idSeq.getNextID();
        this._id_hlprog.put(id, sb);
        this._id_rtprog.put(id, pb);
        this._id_optnode.put(id, n);
        n.setID(id);
        return id;
    }

    public Object[] getRootProgram() {
        Object[] ret = new Object[]{this._prog, this._rtprog};
        return ret;
    }

    public Hop getMappedHop(long id) {
        return (Hop)this._id_hlprog.get(id);
    }

    public Object[] getMappedProg(long id) {
        Object[] ret = new Object[]{this._id_hlprog.get(id), this._id_rtprog.get(id)};
        return ret;
    }

    public ProgramBlock getMappedProgramBlock(long id) {
        return (ProgramBlock)this._id_rtprog.get(id);
    }

    public void replaceMapping(ProgramBlock pb, OptNode n) {
        long id = n.getID();
        this._id_rtprog.put(id, pb);
        this._id_optnode.put(id, n);
    }

    public void clear() {
        this._id_optnode.clear();
        this._prog = null;
        this._rtprog = null;
        this._id_hlprog.clear();
        this._id_rtprog.clear();
    }
}

