/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.authentication.principal;

import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.StringTokenizer;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class X509ExtractorUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(X509ExtractorUtils.class);
    private static final String COMMON_NAME_VAR = "CN";
    private static final int EDIPI_LENGTH = 10;
    private static final int SAN_RFC822_EMAIL_TYPE = 1;

    public static String retrieveTheCommonName(String inSubjectDN) {
        boolean commonNameFound = false;
        String tempCommonName = "";
        StringTokenizer st = new StringTokenizer(inSubjectDN, ",");
        while (!commonNameFound && st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!X509ExtractorUtils.isTokenCommonName(token)) continue;
            commonNameFound = true;
            tempCommonName = token;
        }
        return Strings.CI.remove(tempCommonName, "CN=");
    }

    public static Optional<String> retrieveTheEDIPI(String commonName) {
        StringTokenizer st = new StringTokenizer(commonName, ".");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!X509ExtractorUtils.isTokenEDIPI(token)) continue;
            return Optional.of(token);
        }
        return Optional.empty();
    }

    private static boolean isTokenCommonName(String inToken) {
        StringTokenizer st = new StringTokenizer(inToken, "=");
        return st.nextToken().equals(COMMON_NAME_VAR);
    }

    private static boolean isTokenEDIPI(String inToken) {
        return inToken.length() == 10 && NumberUtils.isCreatable((String)inToken);
    }

    public static Optional<String> getRFC822EmailAddress(Collection<List<?>> subjectAltNames) {
        if (subjectAltNames == null || subjectAltNames.isEmpty()) {
            return Optional.empty();
        }
        return subjectAltNames.stream().filter(name -> name.size() == 2 && (Integer)name.getFirst() == 1).findFirst().map(objects -> (String)objects.get(1));
    }

    public static Collection<List<?>> getSubjectAltNames(X509Certificate certificate) {
        try {
            Collection subjectAltNames = certificate.getSubjectAlternativeNames();
            return subjectAltNames != null ? subjectAltNames : CollectionUtils.emptyCollection();
        }
        catch (CertificateParsingException e) {
            LOGGER.warn("Error parsing certificate for subject alt names [{}]: [{}]", new Object[]{certificate.getSubjectDN(), e.getMessage(), e});
            return CollectionUtils.emptyCollection();
        }
    }

    @Generated
    private X509ExtractorUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

