/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class MaximumIdleDurationLDAPConnectionPoolHealthCheck
extends LDAPConnectionPoolHealthCheck {
    @NotNull
    private final LongAdder idleConnectionCounter;
    private final long maximumIdleDurationMillis;

    public MaximumIdleDurationLDAPConnectionPoolHealthCheck(long maximumIdleDurationValue, @NotNull TimeUnit maximumIdleDurationTimeUnit) {
        this(maximumIdleDurationTimeUnit.toMillis(maximumIdleDurationValue));
    }

    public MaximumIdleDurationLDAPConnectionPoolHealthCheck(long maximumIdleDurationMillis) {
        Validator.ensureTrue(maximumIdleDurationMillis > 0L, "MaximumIdleDurationLDAPConnectionPoolHealthCheck.maximumIdleDurationMillis must be greater than zero.");
        this.maximumIdleDurationMillis = maximumIdleDurationMillis;
        this.idleConnectionCounter = new LongAdder();
    }

    public long getMaximumIdleDurationMillis() {
        return this.maximumIdleDurationMillis;
    }

    public long getIdleConnectionCount() {
        return this.idleConnectionCounter.longValue();
    }

    @Override
    public void ensureConnectionValidForContinuedUse(@NotNull LDAPConnection connection) throws LDAPException {
        long lastCommunicationTime;
        long currentTime = System.currentTimeMillis();
        long idleDurationMillis = currentTime - (lastCommunicationTime = connection.getLastCommunicationTime());
        if (idleDurationMillis > this.maximumIdleDurationMillis) {
            this.idleConnectionCounter.increment();
            throw new LDAPException(ResultCode.TIMEOUT, LDAPMessages.ERR_IDLE_HEALTH_CHECK_CONNECTION_IDLE.get(idleDurationMillis, this.maximumIdleDurationMillis));
        }
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("MaximumIdleDurationLDAPConnectionPoolHealthCheck(maximumIdleDurationMillis=");
        buffer.append(this.maximumIdleDurationMillis);
        buffer.append(')');
    }
}

