/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.cmd.methods;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.tirasa.connid.bundles.cmd.CmdConfiguration;
import net.tirasa.connid.bundles.cmd.methods.CmdExec;
import net.tirasa.connid.bundles.cmd.search.Operand;
import org.identityconnectors.common.Pair;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Uid;

public class CmdExecuteQuery
extends CmdExec {
    private static final Log LOG = Log.getLog(CmdExecuteQuery.class);
    private static final String ITEM_SEPARATOR = "--- NEW SEARCH RESULT ITEM ---";
    private final Operand filter;
    private final ResultsHandler resultsHandler;

    public CmdExecuteQuery(ObjectClass oc, CmdConfiguration cmdConfiguration, Operand filter, ResultsHandler rh) {
        super(oc, cmdConfiguration);
        this.filter = filter;
        this.resultsHandler = rh;
    }

    public void execQuery() throws ConnectException {
        Process proc;
        if (this.filter == null) {
            LOG.ok("Full search (no filter) ...", new Object[0]);
            proc = this.exec(this.cmdConfiguration.getSearchCmdPath(), this.cmdConfiguration.isServerInfoEnv() ? this.getConfigurationEnvs(this.cmdConfiguration) : null);
            this.readOutput(proc);
        } else {
            LOG.ok("Search with filter {0} ...", new Object[]{this.filter});
            proc = this.exec(this.cmdConfiguration.getSearchCmdPath(), this.createEnv());
            switch (this.filter.getOperator()) {
                case EQ: 
                case SW: 
                case EW: 
                case C: {
                    this.readOutput(proc);
                }
                case OR: {
                    break;
                }
                case AND: {
                    break;
                }
                default: {
                    throw new ConnectorException("Wrong Operator");
                }
            }
        }
        this.waitFor(proc);
    }

    private List<Pair<String, String>> createEnv() {
        ArrayList<Pair<String, String>> attributes = new ArrayList<Pair<String, String>>();
        LOG.ok("Creating environment for search with:", new Object[0]);
        LOG.ok("OBJECT_CLASS: {0}", new Object[]{this.oc.getObjectClassValue()});
        LOG.ok("Query filter {0}= {1}", new Object[]{this.filter.getAttributeName(), this.filter.getAttributeValue()});
        attributes.add(new Pair((Object)this.filter.getAttributeName(), (Object)this.filter.getAttributeValue()));
        attributes.add(new Pair((Object)"OBJECT_CLASS", (Object)this.oc.getObjectClassValue()));
        attributes.add(new Pair((Object)"Operator", (Object)this.filter.getOperator().toString()));
        if (this.cmdConfiguration.isServerInfoEnv()) {
            attributes.addAll(this.getConfigurationEnvs(this.cmdConfiguration));
        }
        return attributes;
    }

    private void fillUserHandler(String searchScriptOutput) throws ConnectException {
        if (searchScriptOutput == null || searchScriptOutput.isEmpty()) {
            throw new ConnectException("No results found");
        }
        Properties attrs = StringUtil.toProperties((String)searchScriptOutput);
        ConnectorObjectBuilder bld = new ConnectorObjectBuilder();
        for (Map.Entry<Object, Object> attr : attrs.entrySet()) {
            String name = attr.getKey().toString();
            String value = attr.getValue().toString();
            if (Name.NAME.equalsIgnoreCase(name) && StringUtil.isNotBlank((String)value)) {
                bld.setName(value);
                continue;
            }
            if (Uid.NAME.equals(name)) {
                bld.setUid(value);
                continue;
            }
            if (OperationalAttributes.ENABLE_NAME.equals(name)) {
                bld.addAttribute(new Attribute[]{AttributeBuilder.buildEnabled((boolean)Boolean.parseBoolean(value))});
                continue;
            }
            if (OperationalAttributes.PASSWORD_NAME.equals(name)) {
                bld.addAttribute(new Attribute[]{AttributeBuilder.buildPassword((GuardedString)new GuardedString(value.toCharArray()))});
                continue;
            }
            bld.addAttribute(name, new Object[]{value});
        }
        bld.setObjectClass(this.oc);
        this.resultsHandler.handle(bld.build());
    }

    private void readOutput(Process proc) {
        LOG.info("Read for script output ...", new Object[0]);
        BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        StringBuilder buffer = new StringBuilder();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (line.contains(ITEM_SEPARATOR)) {
                    if (buffer.length() <= 0) continue;
                    LOG.ok("Handle result item {0}", new Object[]{buffer.toString()});
                    this.fillUserHandler(buffer.toString());
                    buffer.delete(0, buffer.length());
                    continue;
                }
                buffer.append(line).append("\n");
            }
            if (buffer.length() > 0) {
                LOG.ok("Handle result item {0}", new Object[]{buffer.toString()});
                this.fillUserHandler(buffer.toString());
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e, "Error reading result items", new Object[0]);
        }
        try {
            br.close();
        }
        catch (IOException e) {
            LOG.ok((Throwable)e, "Error closing reader", new Object[0]);
        }
    }
}

