/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service.wa;

import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.wa.GoogleMfaAuthAccount;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Tag(name="WA")
@SecurityRequirements(value={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
@Path(value="wa/gauth/accts")
public interface GoogleMfaAuthAccountService
extends JAXRSService {
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public PagedResult<GoogleMfaAuthAccount> list();

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{owner}")
    public PagedResult<GoogleMfaAuthAccount> read(@NotNull @PathParam(value="owner") String var1);

    @GET
    @Path(value="devices/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GoogleMfaAuthAccount read(@NotNull @PathParam(value="id") long var1);

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void create(@NotNull GoogleMfaAuthAccount var1);

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void update(@NotNull GoogleMfaAuthAccount var1);

    @DELETE
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{owner}")
    public void delete(@NotNull @PathParam(value="owner") String var1);

    @DELETE
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="devices/{id}")
    public void delete(@NotNull @PathParam(value="id") long var1);

    @DELETE
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void deleteAll();
}

