/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.crypto.DecodableCipher;
import org.apereo.cas.util.crypto.EncodableCipher;
import org.apereo.cas.util.function.FunctionUtils;
import org.jooq.lambda.Unchecked;
import org.jooq.lambda.fi.util.function.CheckedConsumer;

public final class SerializationUtils {
    public static String serializeBase64(Serializable object) {
        return (String)FunctionUtils.doUnchecked(() -> {
            try (ByteArrayOutputStream outBytes = new ByteArrayOutputStream();){
                SerializationUtils.serialize(object, outBytes);
                String string = EncodingUtils.encodeBase64(outBytes.toByteArray());
                return string;
            }
        });
    }

    public static byte[] serialize(Serializable object) {
        return (byte[])FunctionUtils.doUnchecked(() -> {
            try (ByteArrayOutputStream outBytes = new ByteArrayOutputStream();){
                SerializationUtils.serialize(object, outBytes);
                byte[] byArray = outBytes.toByteArray();
                return byArray;
            }
        });
    }

    public static void serialize(Serializable object, OutputStream outputStream) {
        FunctionUtils.doUnchecked((CheckedConsumer<Object>)((CheckedConsumer)__ -> {
            try (ObjectOutputStream out = new ObjectOutputStream(outputStream);){
                out.writeObject(object);
            }
        }), new Object[0]);
    }

    public static <T> T deserialize(byte[] inBytes, Class<T> clazz) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(inBytes);
        return SerializationUtils.deserialize(inputStream, clazz);
    }

    public static <T> T deserialize(InputStream inputStream, Class<T> clazz) {
        return Unchecked.supplier(() -> {
            try (ObjectInputStream in = new ObjectInputStream(inputStream);){
                Object obj = in.readObject();
                if (!clazz.isAssignableFrom(obj.getClass())) {
                    throw new ClassCastException("Result [" + String.valueOf(obj) + " is of type " + String.valueOf(obj.getClass()) + " when we were expecting " + String.valueOf(clazz));
                }
                Object object = obj;
                return object;
            }
        }).get();
    }

    public static byte[] serializeAndEncodeObject(EncodableCipher cipher, Serializable object, Object[] parameters) {
        return (byte[])FunctionUtils.doUnchecked(() -> {
            byte[] outBytes = SerializationUtils.serialize(object);
            return (byte[])cipher.encode((Object)outBytes, parameters);
        });
    }

    public static byte[] serializeAndEncodeObject(EncodableCipher cipher, Serializable object) {
        return SerializationUtils.serializeAndEncodeObject(cipher, object, ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    public static <T extends Serializable> T decodeAndDeserializeObject(byte[] object, DecodableCipher cipher, Class<T> type, Object[] parameters) {
        byte[] decoded = (byte[])cipher.decode((Object)object, parameters);
        return SerializationUtils.deserializeAndCheckObject(decoded, type);
    }

    public static <T extends Serializable> T decodeAndDeserializeObject(byte[] object, DecodableCipher cipher, Class<T> type) {
        return SerializationUtils.decodeAndDeserializeObject(object, cipher, type, ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    public static <T extends Serializable> T deserializeAndCheckObject(byte[] object, Class<T> type) {
        return (T)((Serializable)SerializationUtils.deserialize(object, type));
    }

    @Generated
    private SerializationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

