/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util;

import java.io.InputStream;
import java.net.URI;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.nativex.CasRuntimeHintsRegistrar;

public final class CasVersion {
    private static final String IMPLEMENTATION_DATE = CasRuntimeHintsRegistrar.inNativeImage() ? ZonedDateTime.now(Clock.systemUTC()).toString() : (String)FunctionUtils.doAndHandle(() -> {
        String className = CasVersion.class.getSimpleName() + ".class";
        String classPath = CasVersion.class.getResource(className).toString();
        String manifestPath = classPath.substring(0, classPath.lastIndexOf(33) + 1) + "/META-INF/MANIFEST.MF";
        try (InputStream url = URI.create(manifestPath).toURL().openStream();){
            Manifest manifest = new Manifest(url);
            Attributes attributes = manifest.getMainAttributes();
            String string = (String)StringUtils.defaultIfBlank((CharSequence)attributes.getValue("Implementation-Date"), (CharSequence)ZonedDateTime.now(Clock.systemUTC()).toString());
            return string;
        }
    });

    public static String asString() {
        return CasVersion.getVersion() + " - " + CasVersion.getSpecificationVersion();
    }

    public static String getVersion() {
        return CasVersion.class.getPackage().getImplementationVersion();
    }

    public static String getSpecificationVersion() {
        return CasVersion.class.getPackage().getSpecificationVersion();
    }

    public static ZonedDateTime getDateTime() {
        return IMPLEMENTATION_DATE != null ? DateTimeUtils.zonedDateTimeOf(IMPLEMENTATION_DATE) : ZonedDateTime.now(Clock.systemUTC());
    }

    @Generated
    private CasVersion() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

