/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.BasicIdentifiableCredential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.NullPrincipal;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.email.EmailProperties;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.notifications.mail.EmailCommunicationResult;
import org.apereo.cas.notifications.mail.EmailMessageBodyBuilder;
import org.apereo.cas.notifications.mail.EmailMessageRequest;
import org.apereo.cas.pm.InvalidPasswordException;
import org.apereo.cas.pm.PasswordChangeRequest;
import org.apereo.cas.pm.PasswordManagementQuery;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.PasswordValidationService;
import org.apereo.cas.pm.event.PasswordChangeFailureEvent;
import org.apereo.cas.pm.event.PasswordChangeSuccessEvent;
import org.apereo.cas.pm.web.flow.PasswordManagementWebflowUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class PasswordChangeAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PasswordChangeAction.class);
    private static final String PASSWORD_VALIDATION_FAILURE_CODE = "pm.validationFailure";
    private static final String DEFAULT_MESSAGE = "Could not update the account password";
    private final PasswordManagementService passwordManagementService;
    private final PasswordValidationService passwordValidationService;
    private final AuthenticationSystemSupport authenticationSystemSupport;
    private final PrincipalResolver principalResolver;
    private final CommunicationsManager communicationsManager;
    private final CasConfigurationProperties casProperties;

    protected PasswordChangeRequest getPasswordChangeRequest(RequestContext requestContext) {
        PasswordChangeRequest bean = (PasswordChangeRequest)requestContext.getFlowScope().get("password", PasswordChangeRequest.class);
        bean.setUsername(PasswordManagementWebflowUtils.getPasswordResetUsername(requestContext));
        return bean;
    }

    protected Event doExecuteInternal(RequestContext requestContext) {
        ApplicationContext applicationContext = requestContext.getActiveFlow().getApplicationContext();
        ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
        PasswordChangeRequest bean = this.getPasswordChangeRequest(requestContext);
        try {
            UsernamePasswordCredential credential;
            if ("login".equals(WebUtils.getActiveFlow((RequestContext)requestContext))) {
                LOGGER.debug("Attempting to validate current password for username [{}]", (Object)bean.getUsername());
                credential = (UsernamePasswordCredential)WebUtils.getCredential((RequestContext)requestContext, UsernamePasswordCredential.class);
                if (bean.getCurrentPassword() == null || bean.getCurrentPassword().length == 0 || !Arrays.equals(bean.getCurrentPassword(), credential.getPassword())) {
                    LOGGER.error("Current password is not correct or is undefined");
                    return this.getErrorEvent(requestContext, PASSWORD_VALIDATION_FAILURE_CODE, DEFAULT_MESSAGE, new Object[0]);
                }
            }
            LOGGER.debug("Attempting to validate the password change bean for username [{}]", (Object)bean.getUsername());
            if (StringUtils.isBlank((CharSequence)bean.getUsername()) || !this.passwordValidationService.isValid(bean)) {
                LOGGER.error("Failed to validate the provided password");
                return this.getErrorEvent(requestContext, PASSWORD_VALIDATION_FAILURE_CODE, DEFAULT_MESSAGE, new Object[0]);
            }
            if (this.passwordManagementService.change(bean)) {
                credential = new UsernamePasswordCredential(bean.getUsername(), bean.toPassword());
                WebUtils.putCredential((RequestContext)requestContext, (Credential)credential);
                LOGGER.info("Password successfully changed for [{}]", (Object)bean.getUsername());
                PasswordManagementQuery query = PasswordManagementQuery.builder().username(bean.getUsername()).build();
                String email = this.locatePasswordResetRequestEmail(requestContext, query);
                if (StringUtils.isNotBlank((CharSequence)email)) {
                    EmailCommunicationResult result = this.sendPasswordResetConfirmationEmailToAccount(bean.getUsername(), email, requestContext);
                    LOGGER.debug("Password reset confirmation email sent to [{}] with result [{}]", (Object)result.getTo(), (Object)result.isSuccess());
                }
                applicationContext.publishEvent((ApplicationEvent)new PasswordChangeSuccessEvent((Object)this, clientInfo, bean));
                return this.getSuccessEvent(requestContext, bean);
            }
        }
        catch (InvalidPasswordException e) {
            applicationContext.publishEvent((ApplicationEvent)new PasswordChangeFailureEvent((Object)this, clientInfo, bean, (Throwable)e));
            return this.getErrorEvent(requestContext, PASSWORD_VALIDATION_FAILURE_CODE + (String)StringUtils.defaultIfBlank((CharSequence)e.getCode(), (CharSequence)""), (String)StringUtils.defaultIfBlank((CharSequence)e.getValidationMessage(), (CharSequence)DEFAULT_MESSAGE), e.getParams());
        }
        catch (Throwable e) {
            applicationContext.publishEvent((ApplicationEvent)new PasswordChangeFailureEvent((Object)this, clientInfo, bean, e));
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        return this.getErrorEvent(requestContext, "pm.updateFailure", DEFAULT_MESSAGE, new Object[0]);
    }

    protected Event getSuccessEvent(RequestContext requestContext, PasswordChangeRequest bean) {
        return this.eventFactory.event((Object)this, "passwordUpdateSuccess", (AttributeMap)new LocalAttributeMap("passwordChangeRequest", (Object)bean));
    }

    protected Event getErrorEvent(RequestContext requestContext, String code, String message, Object ... params) {
        WebUtils.addErrorMessageToContext((RequestContext)requestContext, (String)code, (String)message, (Object[])params);
        Object viewStateId = requestContext.getCurrentTransition().getAttributes().get("originalViewState");
        Objects.requireNonNull(viewStateId, "Original view state id cannot be undefined");
        return this.eventFactory.event((Object)this, "error", "originalViewState", viewStateId);
    }

    protected Principal resolvedPrincipal(String username) throws Throwable {
        Principal resolvedPrincipal = this.principalResolver.resolve((Credential)new BasicIdentifiableCredential(username));
        return resolvedPrincipal instanceof NullPrincipal ? this.authenticationSystemSupport.getPrincipalFactory().createPrincipal(username) : resolvedPrincipal;
    }

    protected EmailCommunicationResult sendPasswordResetConfirmationEmailToAccount(String username, String to, RequestContext requestContext) throws Throwable {
        EmailProperties reset = this.casProperties.getAuthn().getPm().getReset().getConfirmationMail();
        Principal person = this.resolvedPrincipal(username);
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        Optional<Locale> locale = Optional.ofNullable(RequestContextUtils.getLocaleResolver((HttpServletRequest)request)).map(resolver -> resolver.resolveLocale(request));
        String text = EmailMessageBodyBuilder.builder().properties(reset).parameters(Map.of("principal", person)).locale(locale).build().get();
        LOGGER.debug("Sending password reset confirmation email to [{}] for username [{}]", (Object)to, (Object)username);
        EmailMessageRequest emailRequest = EmailMessageRequest.builder().emailProperties(reset).principal(person).to(List.of(to)).locale(locale.orElseGet(Locale::getDefault)).body(text).build();
        return this.communicationsManager.email(emailRequest);
    }

    protected String locatePasswordResetRequestEmail(RequestContext requestContext, PasswordManagementQuery query) throws Throwable {
        List emailAttributes = this.casProperties.getAuthn().getPm().getReset().getMail().getAttributeName();
        Principal principal = this.authenticationSystemSupport.getPrincipalResolver().resolve((Credential)new BasicIdentifiableCredential(query.getUsername()));
        return emailAttributes.stream().map(attribute -> (String)principal.getSingleValuedAttribute(attribute, String.class)).filter(StringUtils::isNotBlank).findFirst().orElseGet(Unchecked.supplier(() -> this.passwordManagementService.findEmail(query)));
    }

    @Generated
    public PasswordChangeAction(PasswordManagementService passwordManagementService, PasswordValidationService passwordValidationService, AuthenticationSystemSupport authenticationSystemSupport, PrincipalResolver principalResolver, CommunicationsManager communicationsManager, CasConfigurationProperties casProperties) {
        this.passwordManagementService = passwordManagementService;
        this.passwordValidationService = passwordValidationService;
        this.authenticationSystemSupport = authenticationSystemSupport;
        this.principalResolver = principalResolver;
        this.communicationsManager = communicationsManager;
        this.casProperties = casProperties;
    }

    @Generated
    public PasswordManagementService getPasswordManagementService() {
        return this.passwordManagementService;
    }

    @Generated
    public PasswordValidationService getPasswordValidationService() {
        return this.passwordValidationService;
    }

    @Generated
    public AuthenticationSystemSupport getAuthenticationSystemSupport() {
        return this.authenticationSystemSupport;
    }

    @Generated
    public PrincipalResolver getPrincipalResolver() {
        return this.principalResolver;
    }

    @Generated
    public CommunicationsManager getCommunicationsManager() {
        return this.communicationsManager;
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }
}

