/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.authentication.MultifactorAuthenticationContextValidationResult;
import org.apereo.cas.authentication.MultifactorAuthenticationContextValidator;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderSelector;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.authentication.credential.BasicIdentifiableCredential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.device.MultifactorAuthenticationDeviceManager;
import org.apereo.cas.authentication.principal.NullPrincipal;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.web.flow.PasswordManagementWebflowUtils;
import org.apereo.cas.pm.web.flow.PasswordResetRequest;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.flow.util.MultifactorAuthenticationWebflowUtils;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class InitPasswordResetAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(InitPasswordResetAction.class);
    private final PasswordManagementService passwordManagementService;
    private final CasConfigurationProperties casProperties;
    private final PrincipalResolver principalResolver;
    private final MultifactorAuthenticationProviderSelector multifactorAuthenticationProviderSelector;
    private final AuthenticationSystemSupport authenticationSystemSupport;
    private final MultifactorAuthenticationContextValidator multifactorAuthenticationContextValidator;

    protected Event doExecuteInternal(RequestContext requestContext) throws Throwable {
        Principal resolvedPrincipal;
        MultifactorAuthenticationProvider provider;
        String username = this.getPasswordResetUsername(requestContext);
        if (StringUtils.isBlank((CharSequence)username)) {
            LOGGER.error("Password reset token could not be verified to determine username");
            return this.error();
        }
        if (this.doesPasswordResetRequireMultifactorAuthentication(requestContext) && !this.doesMultifactorAuthenticationProviderExistInContext(requestContext, provider = this.selectMultifactorAuthenticationProvider(requestContext, resolvedPrincipal = this.resolvedPrincipal(username)))) {
            MultifactorAuthenticationDeviceManager deviceManager = provider.getDeviceManager();
            if (deviceManager != null && !deviceManager.hasRegisteredDevices(resolvedPrincipal)) {
                LOGGER.warn("No registered devices for multifactor authentication could be found for [{}] via [{}]", (Object)resolvedPrincipal.getId(), (Object)provider.getId());
                return this.error();
            }
            return this.routeToMultifactorAuthenticationProvider(requestContext, resolvedPrincipal, provider);
        }
        UsernamePasswordCredential credential = new UsernamePasswordCredential();
        credential.setUsername(username);
        WebUtils.putCredential((RequestContext)requestContext, (Credential)credential);
        return this.success();
    }

    protected Event routeToMultifactorAuthenticationProvider(RequestContext requestContext, Principal resolvedPrincipal, MultifactorAuthenticationProvider provider) {
        Authentication authentication = DefaultAuthenticationBuilder.newInstance().setPrincipal(resolvedPrincipal).build();
        WebUtils.putAuthentication((Authentication)authentication, (RequestContext)requestContext);
        AuthenticationResultBuilder builder = this.authenticationSystemSupport.getAuthenticationResultBuilderFactory().newBuilder();
        AuthenticationResultBuilder authenticationResult = builder.collect(authentication);
        WebUtils.putAuthenticationResultBuilder((AuthenticationResultBuilder)authenticationResult, (RequestContext)requestContext);
        WebUtils.putTargetTransition((RequestContext)requestContext, (String)"resumePasswordReset");
        MultifactorAuthenticationWebflowUtils.putMultifactorAuthenticationProvider((RequestContext)requestContext, (MultifactorAuthenticationProvider)provider);
        return this.eventFactory.event((Object)this, provider.getId(), (AttributeMap)new LocalAttributeMap(Map.of(MultifactorAuthenticationProvider.class.getName(), provider)));
    }

    protected Principal resolvedPrincipal(String username) throws Throwable {
        Principal resolvedPrincipal = this.principalResolver.resolve((Credential)new BasicIdentifiableCredential(username));
        return resolvedPrincipal instanceof NullPrincipal ? this.authenticationSystemSupport.getPrincipalFactory().createPrincipal(username) : resolvedPrincipal;
    }

    protected String getPasswordResetUsername(RequestContext requestContext) {
        String token = PasswordManagementWebflowUtils.getPasswordResetToken(requestContext);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            return this.passwordManagementService.parseToken(token);
        }
        PasswordResetRequest request = PasswordManagementWebflowUtils.getPasswordResetRequest(requestContext);
        return request != null ? request.getUsername() : null;
    }

    protected boolean doesMultifactorAuthenticationProviderExistInContext(RequestContext requestContext, MultifactorAuthenticationProvider provider) {
        AuthenticationResultBuilder authResultBuilder = WebUtils.getAuthenticationResultBuilder((RequestContext)requestContext);
        RegisteredService registeredService = WebUtils.getRegisteredService((RequestContext)requestContext);
        return authResultBuilder != null && authResultBuilder.getAuthentications().stream().anyMatch(authentication -> {
            MultifactorAuthenticationContextValidationResult result = this.multifactorAuthenticationContextValidator.validate(authentication, provider.getId(), Optional.ofNullable(registeredService));
            return result.isSuccess() && result.getProvider().isPresent();
        });
    }

    protected MultifactorAuthenticationProvider selectMultifactorAuthenticationProvider(RequestContext requestContext, Principal principal) throws Throwable {
        ApplicationContext applicationContext = requestContext.getActiveFlow().getApplicationContext();
        Map providers = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)applicationContext);
        RegisteredService registeredService = WebUtils.getRegisteredService((RequestContext)requestContext);
        return this.multifactorAuthenticationProviderSelector.resolve(providers.values(), registeredService, principal);
    }

    protected boolean doesPasswordResetRequireMultifactorAuthentication(RequestContext requestContext) {
        ApplicationContext applicationContext = requestContext.getActiveFlow().getApplicationContext();
        Map providers = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)applicationContext);
        String providerId = MultifactorAuthenticationWebflowUtils.getMultifactorAuthenticationProvider((RequestContext)requestContext);
        return this.casProperties.getAuthn().getPm().getReset().isMultifactorAuthenticationEnabled() && !providers.isEmpty() && StringUtils.isBlank((CharSequence)providerId);
    }

    @Generated
    public InitPasswordResetAction(PasswordManagementService passwordManagementService, CasConfigurationProperties casProperties, PrincipalResolver principalResolver, MultifactorAuthenticationProviderSelector multifactorAuthenticationProviderSelector, AuthenticationSystemSupport authenticationSystemSupport, MultifactorAuthenticationContextValidator multifactorAuthenticationContextValidator) {
        this.passwordManagementService = passwordManagementService;
        this.casProperties = casProperties;
        this.principalResolver = principalResolver;
        this.multifactorAuthenticationProviderSelector = multifactorAuthenticationProviderSelector;
        this.authenticationSystemSupport = authenticationSystemSupport;
        this.multifactorAuthenticationContextValidator = multifactorAuthenticationContextValidator;
    }
}

