/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import org.apereo.cas.audit.AuditTrailExecutionPlan;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.attribute.AttributeDefinitionStore;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.logout.slo.SingleLogoutRequestExecutor;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.ServicesManagerConfigurationContext;
import org.apereo.cas.services.util.RegisteredServiceJsonSerializer;
import org.apereo.cas.services.util.RegisteredServiceYamlSerializer;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.proxy.ProxyHandler;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistryCleaner;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.feature.CasRuntimeModuleLoader;
import org.apereo.cas.util.spring.DirectObjectProvider;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.validation.CasProtocolValidationSpecification;
import org.apereo.cas.web.ServiceValidateConfigurationContext;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.report.AttributeDefinitionsEndpoint;
import org.apereo.cas.web.report.AuditLogEndpoint;
import org.apereo.cas.web.report.CasConfigurationEndpoint;
import org.apereo.cas.web.report.CasFeaturesEndpoint;
import org.apereo.cas.web.report.CasInfoEndpointContributor;
import org.apereo.cas.web.report.CasProtocolValidationEndpoint;
import org.apereo.cas.web.report.CasReleaseAttributesReportEndpoint;
import org.apereo.cas.web.report.CasResolveAttributesReportEndpoint;
import org.apereo.cas.web.report.CasRuntimeModulesEndpoint;
import org.apereo.cas.web.report.MultifactorAuthenticationDevicesEndpoint;
import org.apereo.cas.web.report.MultitenancyEndpoint;
import org.apereo.cas.web.report.RegisteredAuthenticationHandlersEndpoint;
import org.apereo.cas.web.report.RegisteredAuthenticationPoliciesEndpoint;
import org.apereo.cas.web.report.RegisteredServiceAccessEndpoint;
import org.apereo.cas.web.report.RegisteredServicesEndpoint;
import org.apereo.cas.web.report.SingleSignOnSessionStatusEndpoint;
import org.apereo.cas.web.report.SingleSignOnSessionsEndpoint;
import org.apereo.cas.web.report.SpringWebflowEndpoint;
import org.apereo.cas.web.report.StatisticsEndpoint;
import org.apereo.cas.web.report.TicketExpirationPoliciesEndpoint;
import org.apereo.cas.web.report.TicketRegistryEndpoint;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.inspektr.common.spi.AuditActionDateProvider;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.info.ConditionalOnEnabledInfoContributor;
import org.springframework.boot.actuate.autoconfigure.info.InfoContributorFallback;
import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.boot.actuate.web.exchanges.HttpExchangeRepository;
import org.springframework.boot.actuate.web.exchanges.HttpExchangesEndpoint;
import org.springframework.boot.actuate.web.exchanges.InMemoryHttpExchangeRepository;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Reports})
@AutoConfiguration
public class CasReportsAutoConfiguration {

    @Configuration(value="MultitenancyEndpointsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Multitenancy})
    static class MultitenancyEndpointsConfiguration {
        MultitenancyEndpointsConfiguration() {
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultitenancyEndpoint multitenancyEndpoint(ConfigurableApplicationContext applicationContext, @Qualifier(value="tenantExtractor") ObjectProvider<TenantExtractor> tenantExtractor, CasConfigurationProperties casProperties) {
            return new MultitenancyEndpoint(casProperties, applicationContext, tenantExtractor);
        }
    }

    @Configuration(value="MultifactorDevicesEndpointsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class MultifactorDevicesEndpointsConfiguration {
        MultifactorDevicesEndpointsConfiguration() {
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationDevicesEndpoint multifactorAuthenticationDevicesEndpoint(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return new MultifactorAuthenticationDevicesEndpoint(casProperties, applicationContext);
        }
    }

    @Configuration(value="TicketingEndpointsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class TicketingEndpointsConfiguration {
        TicketingEndpointsConfiguration() {
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public StatisticsEndpoint statisticsReportEndpoint(@Qualifier(value="ticketRegistry") ObjectProvider<TicketRegistry> ticketRegistry, CasConfigurationProperties casProperties) {
            return new StatisticsEndpoint(ticketRegistry, casProperties);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnAvailableEndpoint
        public TicketExpirationPoliciesEndpoint ticketExpirationPoliciesEndpoint(@Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, @Qualifier(value="servicesManager") ObjectProvider<ServicesManager> servicesManager, CasConfigurationProperties casProperties, List<ExpirationPolicyBuilder> builders) {
            return new TicketExpirationPoliciesEndpoint(casProperties, builders, servicesManager, webApplicationServiceFactory);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnAvailableEndpoint
        public TicketRegistryEndpoint ticketRegistryEndpoint(@Qualifier(value="ticketCatalog") ObjectProvider<TicketCatalog> ticketCatalog, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="defaultTicketRegistrySupport") ObjectProvider<TicketRegistrySupport> ticketRegistrySupport, @Qualifier(value="ticketRegistry") ObjectProvider<TicketRegistry> ticketRegistry, @Qualifier(value="ticketRegistryCleaner") ObjectProvider<TicketRegistryCleaner> ticketRegistryCleaner) {
            return new TicketRegistryEndpoint(casProperties, applicationContext, ticketRegistry, ticketRegistryCleaner, ticketRegistrySupport, ticketCatalog);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnAvailableEndpoint(endpoint=HttpExchangesEndpoint.class)
        public HttpExchangeRepository exchangeRepository() {
            return new InMemoryHttpExchangeRepository();
        }
    }

    @Configuration(value="AuditActivityEndpointsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class AuditActivityEndpointsConfiguration {
        AuditActivityEndpointsConfiguration() {
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditLogEndpoint auditLogEndpoint(@Qualifier(value="defaultAuditActionDateProvider") ObjectProvider<AuditActionDateProvider> defaultAuditActionDateProvider, ConfigurableApplicationContext applicationContext, @Qualifier(value="auditTrailExecutionPlan") ObjectProvider<AuditTrailExecutionPlan> auditTrailExecutionPlan, CasConfigurationProperties casProperties) {
            return new AuditLogEndpoint(auditTrailExecutionPlan, applicationContext, defaultAuditActionDateProvider, casProperties);
        }
    }

    @Configuration(value="RegisteredServicesEndpointsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class RegisteredServicesEndpointsConfiguration {
        RegisteredServicesEndpointsConfiguration() {
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public RegisteredServicesEndpoint registeredServicesReportEndpoint(ObjectProvider<ConfigurableApplicationContext> applicationContext, @Qualifier(value="servicesManagerConfigurationContext") ObjectProvider<ServicesManagerConfigurationContext> configurationContext, @Qualifier(value="servicesManager") ObjectProvider<ServicesManager> servicesManager, CasConfigurationProperties casProperties) {
            List serializers = CollectionUtils.wrapList((Object[])new RegisteredServiceJsonSerializer[]{new RegisteredServiceYamlSerializer((ConfigurableApplicationContext)applicationContext.getObject()), new RegisteredServiceJsonSerializer((ConfigurableApplicationContext)applicationContext.getObject())});
            return new RegisteredServicesEndpoint(casProperties, servicesManager, configurationContext, (ObjectProvider)new DirectObjectProvider((Object)serializers), applicationContext);
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public RegisteredServiceAccessEndpoint registeredServiceAccessEndpoint(ConfigurableApplicationContext applicationContext, @Qualifier(value="argumentExtractor") ObjectProvider<ArgumentExtractor> argumentExtractor, @Qualifier(value="authenticationServiceSelectionPlan") ObjectProvider<AuthenticationServiceSelectionPlan> authenticationServiceSelectionPlan, CasConfigurationProperties casProperties, @Qualifier(value="servicesManager") ObjectProvider<ServicesManager> servicesManager, @Qualifier(value="defaultAuthenticationSystemSupport") ObjectProvider<AuthenticationSystemSupport> authenticationSystemSupport, @Qualifier(value="registeredServiceAccessStrategyEnforcer") ObjectProvider<AuditableExecution> registeredServiceAccessStrategyEnforcer, @Qualifier(value="defaultPrincipalResolver") ObjectProvider<PrincipalResolver> defaultPrincipalResolver, @Qualifier(value="principalFactory") ObjectProvider<PrincipalFactory> principalFactory) {
            return new RegisteredServiceAccessEndpoint(casProperties, applicationContext, servicesManager, authenticationServiceSelectionPlan, argumentExtractor, registeredServiceAccessStrategyEnforcer, authenticationSystemSupport, defaultPrincipalResolver, principalFactory);
        }
    }

    @Configuration(value="SystemInfoEndpointsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SystemInfoEndpointsConfiguration {
        SystemInfoEndpointsConfiguration() {
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasConfigurationEndpoint casConfigurationEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="casConfigurationCipherExecutor") CipherExecutor<String, String> casConfigurationCipherExecutor) {
            return new CasConfigurationEndpoint(casProperties, applicationContext, casConfigurationCipherExecutor);
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasFeaturesEndpoint casFeaturesEndpoint(CasConfigurationProperties casProperties) {
            return new CasFeaturesEndpoint(casProperties);
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SpringWebflowEndpoint springWebflowEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return new SpringWebflowEndpoint(casProperties, (ApplicationContext)applicationContext);
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasRuntimeModulesEndpoint casRuntimeModulesEndpoint(@Qualifier(value="casRuntimeModuleLoader") ObjectProvider<CasRuntimeModuleLoader> casRuntimeModuleLoader, CasConfigurationProperties casProperties) {
            return new CasRuntimeModulesEndpoint(casProperties, casRuntimeModuleLoader);
        }

        @Bean
        @ConditionalOnMissingBean(name={"casInfoEndpointContributor"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnEnabledInfoContributor(value="cas", fallback=InfoContributorFallback.DISABLE)
        public InfoContributor casInfoEndpointContributor(CasConfigurationProperties casProperties, @Qualifier(value="casRuntimeModuleLoader") CasRuntimeModuleLoader casRuntimeModuleLoader) {
            return new CasInfoEndpointContributor(casProperties, casRuntimeModuleLoader);
        }
    }

    @Configuration(value="AuthenticationEndpointsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class AuthenticationEndpointsConfiguration {
        AuthenticationEndpointsConfiguration() {
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public RegisteredAuthenticationHandlersEndpoint registeredAuthenticationHandlersEndpoint(@Qualifier(value="authenticationEventExecutionPlan") ObjectProvider<AuthenticationEventExecutionPlan> authenticationEventExecutionPlan, CasConfigurationProperties casProperties) {
            return new RegisteredAuthenticationHandlersEndpoint(casProperties, authenticationEventExecutionPlan);
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public RegisteredAuthenticationPoliciesEndpoint registeredAuthenticationPoliciesEndpoint(@Qualifier(value="authenticationEventExecutionPlan") ObjectProvider<AuthenticationEventExecutionPlan> authenticationEventExecutionPlan, CasConfigurationProperties casProperties) {
            return new RegisteredAuthenticationPoliciesEndpoint(casProperties, authenticationEventExecutionPlan);
        }
    }

    @Configuration(value="SingleSignOnEndpointsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SingleSignOnEndpointsConfiguration {
        SingleSignOnEndpointsConfiguration() {
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SingleSignOnSessionsEndpoint singleSignOnSessionsEndpoint(ConfigurableApplicationContext applicationContext, @Qualifier(value="ticketRegistry") ObjectProvider<TicketRegistry> ticketRegistry, @Qualifier(value="defaultSingleLogoutRequestExecutor") ObjectProvider<SingleLogoutRequestExecutor> defaultSingleLogoutRequestExecutor, CasConfigurationProperties casProperties) {
            return new SingleSignOnSessionsEndpoint(ticketRegistry, applicationContext, casProperties, defaultSingleLogoutRequestExecutor);
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SingleSignOnSessionStatusEndpoint singleSignOnSessionStatusEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="ticketGrantingTicketCookieGenerator") ObjectProvider<CasCookieBuilder> ticketGrantingTicketCookieGenerator, @Qualifier(value="defaultTicketRegistrySupport") ObjectProvider<TicketRegistrySupport> ticketRegistrySupport) {
            return new SingleSignOnSessionStatusEndpoint(casProperties, applicationContext, ticketGrantingTicketCookieGenerator, ticketRegistrySupport);
        }
    }

    @Configuration(value="AttributesEndpointsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class AttributesEndpointsConfiguration {
        AttributesEndpointsConfiguration() {
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AttributeDefinitionsEndpoint attributeDefinitionsEndpoint(@Qualifier(value="attributeDefinitionStore") ObjectProvider<AttributeDefinitionStore> attributeDefinitionStore, CasConfigurationProperties casProperties) {
            return new AttributeDefinitionsEndpoint(casProperties, attributeDefinitionStore);
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasResolveAttributesReportEndpoint resolveAttributesReportEndpoint(@Qualifier(value="defaultPrincipalResolver") ObjectProvider<PrincipalResolver> defaultPrincipalResolver, CasConfigurationProperties casProperties) {
            return new CasResolveAttributesReportEndpoint(casProperties, defaultPrincipalResolver);
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasReleaseAttributesReportEndpoint releaseAttributesReportEndpoint(ConfigurableApplicationContext applicationContext, @Qualifier(value="defaultPrincipalResolver") ObjectProvider<PrincipalResolver> defaultPrincipalResolver, @Qualifier(value="webApplicationServiceFactory") ObjectProvider<ServiceFactory<WebApplicationService>> webApplicationServiceFactory, @Qualifier(value="defaultAuthenticationSystemSupport") ObjectProvider<AuthenticationSystemSupport> authenticationSystemSupport, @Qualifier(value="principalFactory") ObjectProvider<PrincipalFactory> principalFactory, @Qualifier(value="servicesManager") ObjectProvider<ServicesManager> servicesManager, CasConfigurationProperties casProperties) {
            return new CasReleaseAttributesReportEndpoint(casProperties, applicationContext, servicesManager, authenticationSystemSupport, webApplicationServiceFactory, principalFactory, defaultPrincipalResolver);
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasProtocolValidationEndpoint casProtocolValidationEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="casValidationConfigurationContext") ServiceValidateConfigurationContext casValidationConfigurationContext, @Qualifier(value="proxy20Handler") ProxyHandler proxy20Handler, @Qualifier(value="v3ServiceValidateControllerValidationSpecification") CasProtocolValidationSpecification v3ServiceValidateControllerValidationSpecification) {
            return new CasProtocolValidationEndpoint(casProperties, casValidationConfigurationContext.withValidationSpecifications(CollectionUtils.wrapSet((Object)v3ServiceValidateControllerValidationSpecification)).withProxyHandler(proxy20Handler));
        }
    }
}

