/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.scripting;

import groovy.lang.GroovyClassLoader;
import groovy.lang.Writable;
import groovy.text.GStringTemplateEngine;
import java.io.File;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import org.apereo.cas.util.scripting.ExecutableCompiledScript;
import org.apereo.cas.util.scripting.ExecutableCompiledScriptFactory;
import org.apereo.cas.util.scripting.GroovyShellScript;
import org.apereo.cas.util.scripting.ScriptingUtils;
import org.apereo.cas.util.scripting.WatchableGroovyScriptResource;
import org.springframework.core.io.Resource;

public class GroovyExecutableCompiledScriptFactory
implements ExecutableCompiledScriptFactory {
    public ExecutableCompiledScript fromResource(Resource resource, boolean watchResource) {
        return new WatchableGroovyScriptResource(resource, watchResource);
    }

    public String createTemplate(String contents, Map<String, ?> templateParams) throws Exception {
        GStringTemplateEngine engine = new GStringTemplateEngine();
        Writable template = engine.createTemplate(contents).make(templateParams);
        return template.toString();
    }

    public String createTemplate(File templateFile, Map<String, ?> templateParams) throws Exception {
        GStringTemplateEngine engine = new GStringTemplateEngine();
        Writable template = engine.createTemplate(templateFile).make(templateParams);
        return template.toString();
    }

    public <T> T newObjectInstance(String classText, Class<T> expectedType) throws Exception {
        try (GroovyClassLoader classLoader = (GroovyClassLoader)this.newClassLoader();){
            Class clz = classLoader.parseClass(classText);
            T t = expectedType.cast(clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            return t;
        }
    }

    public <T> T newObjectInstance(Resource resource, Class[] ctorParameters, Object[] args, Class<T> clazz) {
        return ScriptingUtils.getObjectInstanceFromGroovyResource(resource, ctorParameters, args, clazz);
    }

    public Optional<String> getInlineScript(String input) {
        Matcher matcherInline = ScriptingUtils.getMatcherForInlineGroovyScript(input);
        return matcherInline.find() ? Optional.of(matcherInline.group(1)) : Optional.empty();
    }

    public Optional<String> getExternalScript(String input) {
        Matcher matcherFile = ScriptingUtils.getMatcherForExternalGroovyScript(input);
        return matcherFile.find() ? Optional.of(matcherFile.group()) : Optional.empty();
    }

    public ExecutableCompiledScript fromScript(String script) {
        return new GroovyShellScript(script);
    }

    public URLClassLoader newClassLoader() {
        return ScriptingUtils.newGroovyClassLoader();
    }
}

