/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.model;

import java.util.LinkedList;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.webflow.engine.model.AbstractActionModel;
import org.springframework.webflow.engine.model.AbstractTransitionableStateModel;
import org.springframework.webflow.engine.model.BinderModel;
import org.springframework.webflow.engine.model.Model;
import org.springframework.webflow.engine.model.SecuredModel;
import org.springframework.webflow.engine.model.VarModel;

public class ViewStateModel
extends AbstractTransitionableStateModel {
    private String view;
    private String redirect;
    private String popup;
    private String model;
    private String validationHints;
    private LinkedList<VarModel> vars;
    private BinderModel binder;
    private LinkedList<AbstractActionModel> onRenderActions;

    public ViewStateModel(String id) {
        super(id);
    }

    @Override
    public boolean isMergeableWith(Model model) {
        if (!(model instanceof ViewStateModel)) {
            return false;
        }
        ViewStateModel state = (ViewStateModel)model;
        return ObjectUtils.nullSafeEquals((Object)this.getId(), (Object)state.getId());
    }

    @Override
    public void merge(Model model) {
        ViewStateModel state = (ViewStateModel)model;
        this.setParent(null);
        this.setAttributes(this.merge(this.getAttributes(), state.getAttributes()));
        this.setSecured((SecuredModel)this.merge(this.getSecured(), state.getSecured()));
        this.setOnEntryActions(this.merge(this.getOnEntryActions(), state.getOnEntryActions(), false));
        this.setExceptionHandlers(this.merge(this.getExceptionHandlers(), state.getExceptionHandlers()));
        this.setTransitions(this.merge(this.getTransitions(), state.getTransitions()));
        this.setOnExitActions(this.merge(this.getOnExitActions(), state.getOnExitActions(), false));
        this.setView(this.merge(this.getView(), state.getView()));
        this.setRedirect(this.merge(this.getRedirect(), state.getRedirect()));
        this.setPopup(this.merge(this.getPopup(), state.getPopup()));
        this.setModel(this.merge(this.getModel(), state.getModel()));
        this.setValidationHints(this.mergeValidationHints(this.getValidationHints(), state.getValidationHints()));
        this.setVars(this.merge(this.getVars(), state.getVars(), false));
        this.setBinder((BinderModel)this.merge(this.getBinder(), state.getBinder()));
        this.setOnRenderActions(this.merge(this.getOnRenderActions(), state.getOnRenderActions(), false));
    }

    private String mergeValidationHints(String child, String parent) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.hasText((String)child)) {
            sb.append(child);
        }
        if (StringUtils.hasText((String)parent)) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(parent);
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    @Override
    public Model createCopy() {
        ViewStateModel copy = new ViewStateModel(this.getId());
        super.fillCopy(copy);
        copy.setView(this.view);
        copy.setRedirect(this.redirect);
        copy.setPopup(this.popup);
        copy.setModel(this.model);
        copy.setValidationHints(this.validationHints);
        copy.setVars(this.copyList(this.vars));
        copy.setBinder((BinderModel)this.copy(this.binder));
        copy.setOnRenderActions(this.copyList(this.onRenderActions));
        return copy;
    }

    public String getView() {
        return this.view;
    }

    public void setView(String view) {
        this.view = StringUtils.hasText((String)view) ? view : null;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public void setRedirect(String redirect) {
        this.redirect = StringUtils.hasText((String)redirect) ? redirect : null;
    }

    public String getPopup() {
        return this.popup;
    }

    public void setPopup(String popup) {
        this.popup = StringUtils.hasText((String)popup) ? popup : null;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = StringUtils.hasText((String)model) ? model : null;
    }

    public String getValidationHints() {
        return this.validationHints;
    }

    public void setValidationHints(String validationHints) {
        this.validationHints = StringUtils.hasText((String)validationHints) ? validationHints : null;
    }

    public LinkedList<VarModel> getVars() {
        return this.vars;
    }

    public void setVars(LinkedList<VarModel> vars) {
        this.vars = vars;
    }

    public BinderModel getBinder() {
        return this.binder;
    }

    public void setBinder(BinderModel binder) {
        this.binder = binder;
    }

    public LinkedList<AbstractActionModel> getOnRenderActions() {
        return this.onRenderActions;
    }

    public void setOnRenderActions(LinkedList<AbstractActionModel> onRenderActions) {
        this.onRenderActions = onRenderActions;
    }
}

