/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.logout;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.logout.slo.SingleLogoutUrl;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.web.controllers.BaseOidcController;
import org.apereo.cas.oidc.web.controllers.logout.OidcPostLogoutRedirectUrlMatcher;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.web.UrlValidator;
import org.apereo.cas.web.support.WebUtils;
import org.jose4j.jwt.JwtClaims;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.util.UriComponentsBuilder;

@Tag(name="OpenID Connect")
public class OidcLogoutEndpointController
extends BaseOidcController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcLogoutEndpointController.class);
    private final UrlValidator urlValidator;
    private final OidcPostLogoutRedirectUrlMatcher postLogoutRedirectUrlMatcher;

    public OidcLogoutEndpointController(OidcConfigurationContext context, OidcPostLogoutRedirectUrlMatcher postLogoutRedirectUrlMatcher, UrlValidator urlValidator) {
        super(context);
        this.urlValidator = urlValidator;
        this.postLogoutRedirectUrlMatcher = postLogoutRedirectUrlMatcher;
    }

    @GetMapping(value={"/oidc/oidcLogout", "/oidc/logout", "/**/oidcLogout"})
    @Operation(summary="Handle OIDC logout request", parameters={@Parameter(name="post_logout_redirect_uri", description="Post logout redirect URL", in=ParameterIn.QUERY, required=false), @Parameter(name="state", description="State", in=ParameterIn.QUERY, required=false), @Parameter(name="client_id", description="Client ID", in=ParameterIn.QUERY, required=false), @Parameter(name="id_token_hint", description="ID Token hint", in=ParameterIn.QUERY, required=false)})
    public ResponseEntity handleRequestInternal(@RequestParam(value="post_logout_redirect_uri", required=false) String postLogoutRedirectUrl, @RequestParam(value="state", required=false) String state, @RequestParam(value="client_id", required=false) String givenClientId, @RequestParam(value="id_token_hint", required=false) String idToken, HttpServletRequest request, HttpServletResponse response) throws Throwable {
        OidcRegisteredService registeredService;
        if (StringUtils.isNotBlank((CharSequence)idToken)) {
            Optional<String> validURL;
            LOGGER.trace("Decoding logout ID token [{}]", (Object)idToken);
            String clientIdInIdToken = OAuth20Utils.extractClientIdFromToken((String)idToken);
            LOGGER.debug("Client id retrieved from ID token is [{}]", (Object)clientIdInIdToken);
            if (StringUtils.isNotBlank((CharSequence)givenClientId) && !Strings.CI.equals(givenClientId, clientIdInIdToken)) {
                LOGGER.warn("Client id [{}] in logout request does not match client id [{}] in ID token", (Object)givenClientId, (Object)clientIdInIdToken);
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ((OidcConfigurationContext)this.configurationContext).getMessageSource().getMessage("screen.oidc.issuer.invalid", ArrayUtils.EMPTY_OBJECT_ARRAY, request.getLocale()));
            }
            OidcRegisteredService registeredService2 = (OidcRegisteredService)OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)((OidcConfigurationContext)this.getConfigurationContext()).getServicesManager(), (String)clientIdInIdToken, OidcRegisteredService.class);
            JwtClaims idTokenClaims = ((OidcConfigurationContext)this.getConfigurationContext()).getIdTokenSigningAndEncryptionService().decode(idToken, Optional.of(registeredService2));
            Assert.isTrue((boolean)idTokenClaims.getClaimValueAsString("client_id").equalsIgnoreCase(registeredService2.getClientId()), (String)"Client id in ID token does not match client id in registered service");
            Assert.isTrue((boolean)idTokenClaims.hasClaim("aud"), (String)"Audience claim is not present");
            Assert.isTrue((boolean)idTokenClaims.hasClaim("sub"), (String)"Subject claim is not present");
            LOGGER.debug("Located registered service [{}]", (Object)registeredService2);
            WebApplicationService service = (WebApplicationService)((OidcConfigurationContext)this.getConfigurationContext()).getWebApplicationServiceServiceFactory().createService(clientIdInIdToken);
            AuditableContext audit = AuditableContext.builder().service((Service)service).registeredService((RegisteredService)registeredService2).build();
            AuditableExecutionResult accessResult = ((OidcConfigurationContext)this.getConfigurationContext()).getRegisteredServiceAccessStrategyEnforcer().execute(audit);
            accessResult.throwExceptionIfNeeded();
            if (!this.enforceIssuer(request, response, registeredService2)) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ((OidcConfigurationContext)this.configurationContext).getMessageSource().getMessage("screen.oidc.issuer.invalid", ArrayUtils.EMPTY_OBJECT_ARRAY, request.getLocale()));
            }
            WebUtils.putRegisteredService((HttpServletRequest)request, (RegisteredService)((RegisteredService)Objects.requireNonNull(registeredService2)));
            List urls = ((OidcConfigurationContext)this.getConfigurationContext()).getSingleLogoutServiceLogoutUrlBuilder().determineLogoutUrl((RegisteredService)registeredService2, service, Optional.of(request)).stream().map(SingleLogoutUrl::getUrl).collect(Collectors.toList());
            LOGGER.debug("Logout urls assigned to registered service are [{}]", urls);
            if (StringUtils.isNotBlank((CharSequence)postLogoutRedirectUrl) && registeredService2.getMatchingStrategy() != null) {
                boolean matchResult;
                WebApplicationService postLogoutService = (WebApplicationService)((OidcConfigurationContext)this.getConfigurationContext()).getWebApplicationServiceServiceFactory().createService(postLogoutRedirectUrl);
                boolean bl = matchResult = registeredService2.matches(postLogoutRedirectUrl) || urls.stream().anyMatch(url -> this.postLogoutRedirectUrlMatcher.matches(postLogoutRedirectUrl, (String)url)) || ((OidcConfigurationContext)this.getConfigurationContext()).getServicesManager().findServiceBy((Service)postLogoutService) != null;
                if (matchResult) {
                    LOGGER.debug("Requested logout URL [{}] is authorized for redirects", (Object)postLogoutRedirectUrl);
                    return this.executeLogoutRedirect(Optional.ofNullable(StringUtils.trimToNull((String)state)), Optional.of(postLogoutRedirectUrl), Optional.of(clientIdInIdToken), request, response);
                }
            }
            if ((validURL = urls.stream().filter(arg_0 -> ((UrlValidator)this.urlValidator).isValid(arg_0)).findFirst()).isPresent()) {
                return this.executeLogoutRedirect(Optional.ofNullable(StringUtils.trimToNull((String)state)), validURL, Optional.of(clientIdInIdToken), request, response);
            }
            LOGGER.debug("No logout urls could be determined for registered service [{}]", (Object)registeredService2.getName());
        }
        OidcRegisteredService oidcRegisteredService = registeredService = StringUtils.isNotBlank((CharSequence)givenClientId) ? (OidcRegisteredService)OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)((OidcConfigurationContext)this.getConfigurationContext()).getServicesManager(), (String)givenClientId, OidcRegisteredService.class) : null;
        if (!this.enforceIssuer(request, response, registeredService)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ((OidcConfigurationContext)this.configurationContext).getMessageSource().getMessage("screen.oidc.issuer.invalid", ArrayUtils.EMPTY_OBJECT_ARRAY, request.getLocale()));
        }
        return this.executeLogoutRedirect(Optional.ofNullable(StringUtils.trimToNull((String)state)), Optional.empty(), Optional.ofNullable(givenClientId), request, response);
    }

    private boolean enforceIssuer(HttpServletRequest request, HttpServletResponse response, OidcRegisteredService registeredService) {
        JEEContext webContext = new JEEContext(request, response);
        if (!((OidcConfigurationContext)this.getConfigurationContext()).getIssuerService().validateIssuer((WebContext)webContext, List.of("oidcLogout", "logout"), registeredService)) {
            String issuer = ((OidcConfigurationContext)this.getConfigurationContext()).getIssuerService().determineIssuer(Optional.ofNullable(registeredService));
            LOGGER.warn("Logout request is not issued by a trusted issuer: [{}]", (Object)issuer);
            return false;
        }
        return true;
    }

    protected ResponseEntity executeLogoutRedirect(Optional<String> state, Optional<String> redirectUrl, Optional<String> clientId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        redirectUrl.ifPresent(url -> {
            UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)url);
            state.ifPresent(st -> builder.queryParam("state", new Object[]{st}));
            clientId.ifPresent(id -> builder.queryParam("client_id", new Object[]{id}));
            String logoutUrl = builder.build().toUriString();
            LOGGER.debug("Final logout redirect URL is [{}]", (Object)logoutUrl);
            WebUtils.putLogoutRedirectUrl((HttpServletRequest)request, (String)logoutUrl);
        });
        request.setAttribute("status", (Object)HttpStatus.PERMANENT_REDIRECT);
        request.getServletContext().getRequestDispatcher("/logout").forward((ServletRequest)request, (ServletResponse)response);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.PERMANENT_REDIRECT).build();
    }
}

