/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.dynareg;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.dynareg.OidcClientRegistrationRequest;
import org.apereo.cas.oidc.dynareg.OidcClientRegistrationResponse;
import org.apereo.cas.oidc.web.controllers.BaseOidcController;
import org.apereo.cas.oidc.web.controllers.dynareg.OidcClientRegistrationUtils;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Tag(name="OpenID Connect")
public class OidcClientConfigurationEndpointController
extends BaseOidcController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcClientConfigurationEndpointController.class);

    public OidcClientConfigurationEndpointController(OidcConfigurationContext configurationContext) {
        super(configurationContext);
    }

    @GetMapping(value={"/oidc/clientConfig", "/**/clientConfig"}, produces={"application/json"})
    @Operation(summary="Handle client configuration request", parameters={@Parameter(name="client_id", description="Client ID", required=true)})
    public ResponseEntity handleRequestInternal(@RequestParam(name="client_id") String clientId, HttpServletRequest request, HttpServletResponse response) {
        JEEContext webContext = new JEEContext(request, response);
        if (!((OidcConfigurationContext)this.getConfigurationContext()).getIssuerService().validateIssuer((WebContext)webContext, List.of("clientConfig"))) {
            Map body = OAuth20Utils.getErrorResponseBody((String)"invalid_request", (String)"Invalid issuer");
            return new ResponseEntity((Object)body, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        OAuthRegisteredService service = OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)((OidcConfigurationContext)this.getConfigurationContext()).getServicesManager(), (String)clientId);
        if (service instanceof OidcRegisteredService) {
            OidcRegisteredService oidcRegisteredService = (OidcRegisteredService)service;
            String prefix = ((OidcConfigurationContext)this.getConfigurationContext()).getCasProperties().getServer().getPrefix();
            OidcClientRegistrationResponse regResponse = OidcClientRegistrationUtils.getClientRegistrationResponse(oidcRegisteredService, prefix);
            return new ResponseEntity((Object)regResponse, (HttpStatusCode)HttpStatus.OK);
        }
        return ResponseEntity.badRequest().build();
    }

    @PatchMapping(value={"/oidc/clientConfig", "/**/clientConfig"}, produces={"application/json"})
    @Operation(summary="Handle client configuration updates", parameters={@Parameter(name="client_id", in=ParameterIn.QUERY, description="Client ID", required=true)}, requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(description="Client registration request", content={@Content(mediaType="application/json", schema=@Schema(implementation=OidcClientRegistrationRequest.class))}))
    public ResponseEntity handleUpdates(@RequestParam(name="client_id") String clientId, @RequestBody(required=false) String jsonInput, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JEEContext webContext = new JEEContext(request, response);
        if (!((OidcConfigurationContext)this.getConfigurationContext()).getIssuerService().validateIssuer((WebContext)webContext, List.of("clientConfig"))) {
            Map body = OAuth20Utils.getErrorResponseBody((String)"invalid_request", (String)"Invalid issuer");
            return new ResponseEntity((Object)body, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        OidcRegisteredService service = (OidcRegisteredService)OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)((OidcConfigurationContext)this.getConfigurationContext()).getServicesManager(), (String)clientId, OidcRegisteredService.class);
        if (service != null) {
            long clientSecretExp;
            if (StringUtils.isNotBlank((CharSequence)jsonInput)) {
                OidcClientRegistrationRequest registrationRequest = (OidcClientRegistrationRequest)((OidcConfigurationContext)this.getConfigurationContext()).getClientRegistrationRequestSerializer().from(jsonInput);
                LOGGER.debug("Received client registration request [{}]", (Object)registrationRequest);
                service = ((OidcConfigurationContext)this.getConfigurationContext()).getClientRegistrationRequestTranslator().translate(registrationRequest, Optional.of(service));
            }
            if ((clientSecretExp = Beans.newDuration((String)((OidcConfigurationContext)this.getConfigurationContext()).getCasProperties().getAuthn().getOidc().getRegistration().getClientSecretExpiration()).toSeconds()) > 0L && ((OidcConfigurationContext)this.getConfigurationContext()).getClientSecretValidator().isClientSecretExpired((OAuthRegisteredService)service)) {
                ZonedDateTime currentTime = ZonedDateTime.now(ZoneOffset.UTC);
                ZonedDateTime expirationDate = currentTime.plusSeconds(clientSecretExp);
                service.setClientSecretExpiration(expirationDate.toEpochSecond());
                service.setClientSecret(((OidcConfigurationContext)this.getConfigurationContext()).getClientSecretGenerator().getNewString());
                LOGGER.debug("Client secret shall expire at [{}] while now is [{}]", (Object)expirationDate, (Object)currentTime);
            }
            OidcClientRegistrationResponse clientResponse = OidcClientRegistrationUtils.getClientRegistrationResponse(service, ((OidcConfigurationContext)this.getConfigurationContext()).getCasProperties().getServer().getPrefix());
            return new ResponseEntity((Object)clientResponse, (HttpStatusCode)HttpStatus.OK);
        }
        return ResponseEntity.badRequest().build();
    }
}

