/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.authorize;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.web.controllers.authorize.OidcAuthorizeEndpointController;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.servlet.ModelAndView;

@Tag(name="OpenID Connect")
public class OidcPushedAuthorizeEndpointController
extends OidcAuthorizeEndpointController {
    public OidcPushedAuthorizeEndpointController(OidcConfigurationContext configurationContext) {
        super(configurationContext);
    }

    @Override
    @GetMapping(value={"/**/oidcPushAuthorize"})
    @Operation(summary="Handle OIDC Pushed authorization request")
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) {
        return OAuth20Utils.produceUnauthorizedErrorView((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED);
    }

    @Override
    @PostMapping(value={"/**/oidcPushAuthorize"})
    @Operation(summary="Handle OIDC Pushed authorization request")
    public ModelAndView handleRequestPost(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        JEEContext webContext = new JEEContext(request, response);
        if (!((OidcConfigurationContext)this.getConfigurationContext()).getIssuerService().validateIssuer((WebContext)webContext, List.of("oidcPushAuthorize"))) {
            return OAuth20Utils.writeError((HttpServletResponse)response, (String)"invalid_request", (String)"Invalid issuer");
        }
        return super.handleRequest(request, response);
    }
}

