/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.authorize;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20AuthorizeEndpointController;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.servlet.ModelAndView;

@Tag(name="OpenID Connect")
public class OidcAuthorizeEndpointController
extends OAuth20AuthorizeEndpointController<OidcConfigurationContext> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcAuthorizeEndpointController.class);

    public OidcAuthorizeEndpointController(OidcConfigurationContext configurationContext) {
        super((OAuth20ConfigurationContext)configurationContext);
    }

    @GetMapping(value={"/oidc/authorize", "/**/oidcAuthorize"})
    @Operation(summary="Handle OIDC authorization request")
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        JEEContext webContext = new JEEContext(request, response);
        if (!((OidcConfigurationContext)this.getConfigurationContext()).getIssuerService().validateIssuer((WebContext)webContext, List.of("oidcAuthorize", "authorize"))) {
            LOGGER.warn("CAS cannot accept the authorization request given the issuer is invalid.");
            return OAuth20Utils.writeError((HttpServletResponse)response, (String)"invalid_request", (String)"Invalid issuer");
        }
        if (((OidcConfigurationContext)this.getConfigurationContext()).getDiscoverySettings().isRequirePushedAuthorizationRequests() && webContext.getRequestURL().endsWith("oidcAuthorize") && StringUtils.isBlank((CharSequence)request.getParameter("request_uri"))) {
            LOGGER.warn("CAS is configured to only accept pushed authorization requests");
            return OAuth20Utils.produceUnauthorizedErrorView((HttpStatus)HttpStatus.FORBIDDEN);
        }
        Collection scopes = ((OidcConfigurationContext)this.getConfigurationContext()).getRequestParameterResolver().resolveRequestedScopes((WebContext)webContext);
        if (scopes.isEmpty() || !scopes.contains(OidcConstants.StandardScopes.OPENID.getScope())) {
            LOGGER.warn("Provided scopes [{}] are undefined by OpenID Connect, which requires that scope [{}] MUST be specified, or the behavior is unspecified. CAS MAY allow this request to be processed for now.", (Object)scopes, (Object)OidcConstants.StandardScopes.OPENID.getScope());
        }
        return super.handleRequest(request, response);
    }

    @PostMapping(value={"/oidc/authorize", "/**/oidcAuthorize"})
    @Operation(summary="Handle OIDC authorization request")
    public ModelAndView handleRequestPost(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        return this.handleRequest(request, response);
    }
}

