/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.login;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.NullPrincipal;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.http.HttpRequestUtils;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.SingleSignOnParticipationRequest;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.support.CookieUtils;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class InitialFlowSetupAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(InitialFlowSetupAction.class);
    private final List<ArgumentExtractor> argumentExtractors;
    private final ServicesManager servicesManager;
    private final AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies;
    private final CasCookieBuilder ticketGrantingTicketCookieGenerator;
    private final CasCookieBuilder warnCookieGenerator;
    private final CasConfigurationProperties casProperties;
    private final AuthenticationEventExecutionPlan authenticationEventExecutionPlan;
    private final SingleSignOnParticipationStrategy renewalStrategy;
    private final TicketRegistrySupport ticketRegistrySupport;

    protected static void configureWebflowForPostParameters(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        if (request.getMethod().equalsIgnoreCase(HttpMethod.POST.name())) {
            WebUtils.putInitialHttpRequestPostParameters((RequestContext)context);
        }
    }

    protected Event doExecuteInternal(RequestContext context) throws Throwable {
        this.configureCookieGenerators(context);
        InitialFlowSetupAction.configureWebflowForPostParameters(context);
        this.configureWebflowForCustomFields(context);
        this.configureWebflowForServices(context);
        this.configureWebflowContext(context);
        String ticketGrantingTicketId = this.configureWebflowForTicketGrantingTicket(context);
        this.configureWebflowForSsoParticipation(context, ticketGrantingTicketId);
        return this.success();
    }

    protected String configureWebflowForTicketGrantingTicket(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        String ticketGrantingTicketId = this.ticketGrantingTicketCookieGenerator.retrieveCookieValue(request);
        LOGGER.trace("Retrieved the ticket-granting ticket identifier in the login webflow: [{}]", (Object)ticketGrantingTicketId);
        TicketGrantingTicket ticket = this.ticketRegistrySupport.getTicketGrantingTicket(ticketGrantingTicketId);
        LOGGER.trace("Retrieved the ticket-granting ticket in the login webflow: [{}]", (Object)ticket);
        if (ticket != null) {
            WebUtils.putTicketGrantingTicketInScopes((RequestContext)context, (String)ticket.getId());
            return ticket.getId();
        }
        this.clearTicketGrantingCookieFromContext(context);
        return null;
    }

    protected void clearTicketGrantingCookieFromContext(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)context);
        this.ticketGrantingTicketCookieGenerator.removeAll(request, response);
        WebUtils.putTicketGrantingTicketInScopes((RequestContext)context, (String)"");
    }

    protected void configureWebflowForCustomFields(RequestContext context) {
        WebUtils.putCustomLoginFormFields((RequestContext)context, (Map)this.casProperties.getView().getCustomLoginFormFields());
    }

    protected void configureWebflowForServices(RequestContext context) {
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)context);
        if (HttpStatus.valueOf((int)response.getStatus()).isError()) {
            throw UnauthorizedServiceException.denied((String)"Denied");
        }
        WebApplicationService service = WebUtils.getService(this.argumentExtractors, (RequestContext)context);
        if (service != null) {
            LOGGER.debug("Placing service in context scope: [{}]", (Object)service.getId());
            Service selectedService = (Service)FunctionUtils.doUnchecked(() -> this.authenticationRequestServiceSelectionStrategies.resolveService((Service)service));
            RegisteredService registeredService = this.servicesManager.findServiceBy(selectedService);
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)service, (RegisteredService)registeredService);
            if (registeredService != null && registeredService.getAccessStrategy().isServiceAccessAllowed(registeredService, selectedService)) {
                LOGGER.debug("Placing registered service [{}] with id [{}] in context scope", (Object)registeredService.getServiceId(), (Object)registeredService.getId());
                WebUtils.putRegisteredService((RequestContext)context, (RegisteredService)registeredService);
                WebUtils.putWildcardedRegisteredService((RequestContext)context, (boolean)RegisteredServiceProperty.RegisteredServiceProperties.WILDCARDED_SERVICE_DEFINITION.isAssignedTo(registeredService));
                RegisteredServiceAccessStrategy accessStrategy = registeredService.getAccessStrategy();
                if (accessStrategy.getUnauthorizedRedirectUrl() != null) {
                    LOGGER.debug("Placing registered service's unauthorized redirect url [{}] with id [{}] in context scope", (Object)accessStrategy.getUnauthorizedRedirectUrl(), (Object)registeredService.getServiceId());
                    WebUtils.putUnauthorizedRedirectUrlIntoFlowScope((RequestContext)context, (URI)accessStrategy.getUnauthorizedRedirectUrl());
                }
            }
            WebUtils.putServiceIntoFlowScope((RequestContext)context, (Service)service);
        }
    }

    protected void configureWebflowForSsoParticipation(RequestContext context, String ticketGrantingTicketId) throws Throwable {
        boolean ssoParticipation;
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)context);
        SingleSignOnParticipationRequest ssoRequest = SingleSignOnParticipationRequest.builder().requestContext(context).httpServletRequest(request).httpServletResponse(response).build();
        boolean bl = ssoParticipation = this.renewalStrategy.supports(ssoRequest) && this.renewalStrategy.isParticipating(ssoRequest);
        if (!ssoParticipation && StringUtils.isNotBlank((CharSequence)ticketGrantingTicketId)) {
            Authentication auth = this.ticketRegistrySupport.getAuthenticationFrom(ticketGrantingTicketId);
            WebUtils.putExistingSingleSignOnSessionAvailable((RequestContext)context, (auth != null ? 1 : 0) != 0);
            WebUtils.putExistingSingleSignOnSessionPrincipal((RequestContext)context, (Principal)Optional.ofNullable(auth).map(Authentication::getPrincipal).orElseGet(NullPrincipal::getInstance));
            WebUtils.putTicketGrantingTicketInScopes((RequestContext)context, (String)"");
        }
    }

    protected void configureWebflowContext(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        WebUtils.putWarningCookie((RequestContext)context, (Boolean)Boolean.valueOf(this.warnCookieGenerator.retrieveCookieValue(request)));
        WebUtils.putGeoLocationTrackingIntoFlowScope((RequestContext)context, (Object)this.casProperties.getEvents().getCore().isTrackGeolocation());
        WebUtils.putRememberMeAuthenticationEnabled((RequestContext)context, (Boolean)this.casProperties.getTicket().getTgt().getRememberMe().isEnabled());
        boolean staticAuthEnabled = this.casProperties.getAuthn().getAccept().isEnabled() && StringUtils.isNotBlank((CharSequence)this.casProperties.getAuthn().getAccept().getUsers()) || StringUtils.isNotBlank((CharSequence)this.casProperties.getAuthn().getReject().getUsers());
        WebUtils.putStaticAuthenticationIntoFlowScope((RequestContext)context, (Object)staticAuthEnabled);
        if (this.casProperties.getAuthn().getPolicy().isSourceSelectionEnabled()) {
            List<String> availableHandlers = this.determineAuthenticationHandlersForSourceSelection(context);
            WebUtils.putAvailableAuthenticationHandleNames((RequestContext)context, availableHandlers);
        }
        context.getFlowScope().put("httpRequestSecure", (Object)request.isSecure());
        context.getFlowScope().put("httpRequestMethod", (Object)request.getMethod());
        context.getFlowScope().put("httpRequestHeaders", (Object)HttpRequestUtils.getRequestHeaders((HttpServletRequest)request));
    }

    protected List<String> determineAuthenticationHandlersForSourceSelection(RequestContext context) {
        Set requiredHandlers;
        List<String> availableHandlers = this.authenticationEventExecutionPlan.resolveAuthenticationHandlers().stream().filter(handler -> handler.supports(UsernamePasswordCredential.class)).map(handler -> StringUtils.capitalize((String)handler.getName().trim())).distinct().sorted().collect(Collectors.toList());
        RegisteredService registeredService = WebUtils.getRegisteredService((RequestContext)context);
        if (registeredService != null && registeredService.getAuthenticationPolicy() != null && (requiredHandlers = registeredService.getAuthenticationPolicy().getRequiredAuthenticationHandlers()) != null && !requiredHandlers.isEmpty()) {
            availableHandlers.removeIf(handler -> !requiredHandlers.contains(handler));
        }
        return availableHandlers;
    }

    protected void configureCookieGenerators(RequestContext context) {
        CookieUtils.configureCookiePath((RequestContext)context, (CasCookieBuilder)this.warnCookieGenerator);
        CookieUtils.configureCookiePath((RequestContext)context, (CasCookieBuilder)this.ticketGrantingTicketCookieGenerator);
    }

    @Generated
    public InitialFlowSetupAction(List<ArgumentExtractor> argumentExtractors, ServicesManager servicesManager, AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies, CasCookieBuilder ticketGrantingTicketCookieGenerator, CasCookieBuilder warnCookieGenerator, CasConfigurationProperties casProperties, AuthenticationEventExecutionPlan authenticationEventExecutionPlan, SingleSignOnParticipationStrategy renewalStrategy, TicketRegistrySupport ticketRegistrySupport) {
        this.argumentExtractors = argumentExtractors;
        this.servicesManager = servicesManager;
        this.authenticationRequestServiceSelectionStrategies = authenticationRequestServiceSelectionStrategies;
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
        this.warnCookieGenerator = warnCookieGenerator;
        this.casProperties = casProperties;
        this.authenticationEventExecutionPlan = authenticationEventExecutionPlan;
        this.renewalStrategy = renewalStrategy;
        this.ticketRegistrySupport = ticketRegistrySupport;
    }

    @Generated
    public List<ArgumentExtractor> getArgumentExtractors() {
        return this.argumentExtractors;
    }

    @Generated
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Generated
    public AuthenticationServiceSelectionPlan getAuthenticationRequestServiceSelectionStrategies() {
        return this.authenticationRequestServiceSelectionStrategies;
    }

    @Generated
    public CasCookieBuilder getTicketGrantingTicketCookieGenerator() {
        return this.ticketGrantingTicketCookieGenerator;
    }

    @Generated
    public CasCookieBuilder getWarnCookieGenerator() {
        return this.warnCookieGenerator;
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }

    @Generated
    public AuthenticationEventExecutionPlan getAuthenticationEventExecutionPlan() {
        return this.authenticationEventExecutionPlan;
    }

    @Generated
    public SingleSignOnParticipationStrategy getRenewalStrategy() {
        return this.renewalStrategy;
    }

    @Generated
    public TicketRegistrySupport getTicketRegistrySupport() {
        return this.ticketRegistrySupport;
    }
}

