/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.syncope;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.authentication.attribute.BasePersonAttributeDao;
import org.apereo.cas.authentication.attribute.SimplePersonAttributes;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDao;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDaoFilter;
import org.apereo.cas.authentication.principal.attribute.PersonAttributes;
import org.apereo.cas.configuration.model.support.syncope.BaseSyncopeSearchProperties;
import org.apereo.cas.configuration.model.support.syncope.SyncopePrincipalAttributesProperties;
import org.apereo.cas.syncope.SyncopeUtils;

public class SyncopePersonAttributeDao
extends BasePersonAttributeDao {
    private final SyncopePrincipalAttributesProperties properties;

    public PersonAttributes getPerson(String uid, Set<PersonAttributes> resolvedPeople, PersonAttributeDaoFilter filter) {
        HashMap attributes = new HashMap();
        List<Map<String, List<Object>>> results = this.syncopeUserSearch(uid);
        results.forEach(attributes::putAll);
        if (this.properties.isIncludeUserGroups()) {
            List<Map<String, List<Object>>> groups = this.syncopeUserGroupsSearch(uid);
            groups.forEach(attributes::putAll);
        }
        return new SimplePersonAttributes(uid, attributes);
    }

    public Set<PersonAttributes> getPeople(Map<String, Object> map, PersonAttributeDaoFilter filter, Set<PersonAttributes> resolvedPeople) {
        return this.getPeopleWithMultivaluedAttributes(PersonAttributeDao.stuffAttributesIntoList(map), filter);
    }

    public Set<PersonAttributes> getPeopleWithMultivaluedAttributes(Map<String, List<Object>> map, PersonAttributeDaoFilter filter, Set<PersonAttributes> resolvedPeople) {
        return map.entrySet().stream().filter(e -> Objects.nonNull(e.getValue())).filter(e -> !((List)e.getValue()).isEmpty()).filter(e -> this.properties.getSearchFilter().contains((CharSequence)e.getKey())).findFirst().map(e -> Set.of(this.getPerson(((List)e.getValue()).getFirst().toString(), resolvedPeople, filter))).orElseGet(LinkedHashSet::new);
    }

    protected List<Map<String, List<Object>>> syncopeUserSearch(String username) {
        return SyncopeUtils.syncopeUserSearch((BaseSyncopeSearchProperties)this.properties, username);
    }

    protected List<Map<String, List<Object>>> syncopeUserGroupsSearch(String username) {
        return SyncopeUtils.syncopeUserGroupsSearch((BaseSyncopeSearchProperties)this.properties, username);
    }

    @Generated
    public SyncopePersonAttributeDao(SyncopePrincipalAttributesProperties properties) {
        this.properties = properties;
    }
}

