/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.logout;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import lombok.Generated;
import org.apereo.cas.authentication.principal.WebApplicationServiceFactory;
import org.apereo.cas.configuration.model.core.logout.LogoutProperties;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.web.UrlValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogoutWebApplicationServiceFactory
extends WebApplicationServiceFactory {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LogoutWebApplicationServiceFactory.class);
    private final LogoutProperties logoutProperties;

    public LogoutWebApplicationServiceFactory(TenantExtractor tenantExtractor, UrlValidator urlValidator, LogoutProperties logoutProperties) {
        super(tenantExtractor, urlValidator);
        this.logoutProperties = logoutProperties;
    }

    protected String getRequestedService(HttpServletRequest request) {
        if (request.getRequestURI().endsWith("/logout")) {
            String service = this.logoutProperties.getRedirectParameter().stream().map(paramName -> {
                LOGGER.trace("Using request parameter name [{}] to detect destination service, if any", paramName);
                return request.getParameter(paramName);
            }).filter(Objects::nonNull).findFirst().orElse("");
            LOGGER.trace("Located target service [{}] for redirection after logout", (Object)service);
            return service;
        }
        return null;
    }
}

