/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.keymaster.client.self;

import jakarta.ws.rs.client.CompletionStageRxInvoker;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Strings;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.transport.common.gzip.GZIPInInterceptor;
import org.apache.cxf.transport.common.gzip.GZIPOutInterceptor;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.ConnectionType;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;

abstract class SelfKeymasterOps {
    protected final Map<Class<?>, Object> services = Collections.synchronizedMap(new HashMap());
    private final JAXRSClientFactoryBean clientFactory;
    protected HTTPClientPolicy httpClientPolicy;

    protected SelfKeymasterOps(JAXRSClientFactoryBean clientFactory) {
        this.clientFactory = clientFactory;
        this.httpClientPolicy = new HTTPClientPolicy();
        this.httpClientPolicy.setConnection(ConnectionType.CLOSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T client(Class<T> serviceClass, Map<String, String> headers) {
        Object service;
        if (this.services.containsKey(serviceClass)) {
            service = this.services.get(serviceClass);
        } else {
            JAXRSClientFactoryBean jAXRSClientFactoryBean = this.clientFactory;
            synchronized (jAXRSClientFactoryBean) {
                this.clientFactory.setServiceClass(serviceClass);
                this.clientFactory.setHeaders(headers);
                service = this.clientFactory.create(serviceClass, new Object[0]);
            }
            this.services.put(serviceClass, service);
            Client client = WebClient.client((Object)service);
            client.type("application/json").accept(new String[]{"application/json"});
            ClientConfiguration config = WebClient.getConfig((Object)client);
            config.getInInterceptors().add(new GZIPInInterceptor());
            config.getOutInterceptors().add(new GZIPOutInterceptor());
            HTTPConduit httpConduit = (HTTPConduit)config.getConduit();
            httpConduit.setClient(this.httpClientPolicy);
        }
        return (T)service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletionStageRxInvoker rx(String path) {
        JAXRSClientFactoryBean jAXRSClientFactoryBean = this.clientFactory;
        synchronized (jAXRSClientFactoryBean) {
            CompletionStageRxInvoker completionStageRxInvoker;
            String original = this.clientFactory.getAddress();
            this.clientFactory.setAddress(Strings.CS.removeEnd(original, (CharSequence)"/") + Strings.CS.prependIfMissing(path, (CharSequence)"/", new CharSequence[0]));
            try {
                WebClient client = this.clientFactory.createWebClient().type("application/json").accept(new String[]{"application/json"});
                completionStageRxInvoker = client.rx();
            }
            catch (Throwable throwable) {
                this.clientFactory.setAddress(original);
                throw throwable;
            }
            this.clientFactory.setAddress(original);
            return completionStageRxInvoker;
        }
    }
}

