/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.decoder.httpclient;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.xml.ParserPool;
import net.shibboleth.shared.xml.SerializeSupport;
import net.shibboleth.shared.xml.XMLParserException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.decoder.httpclient.AbstractHttpClientResponseMessageDecoder;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BaseHttpClientResponseXMLMessageDecoder
extends AbstractHttpClientResponseMessageDecoder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BaseHttpClientResponseXMLMessageDecoder.class);
    @NonnullAfterInit
    private ParserPool parserPool = XMLObjectProviderRegistrySupport.getParserPool();

    @Override
    public void decode() throws MessageDecodingException {
        this.log.debug("Beginning to decode message from HttpResponse");
        super.decode();
        this.log.debug("Successfully decoded message from HttpResponse");
    }

    @NonnullAfterInit
    public ParserPool getParserPool() {
        return this.parserPool;
    }

    public void setParserPool(@Nonnull ParserPool pool) {
        this.checkSetterPreconditions();
        this.parserPool = (ParserPool)Constraint.isNotNull((Object)pool, (String)"ParserPool cannot be null");
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.parserPool == null) {
            throw new ComponentInitializationException("Parser pool cannot be null");
        }
    }

    @Override
    @Nullable
    protected String serializeMessageForLogging(@Nullable Object message) {
        if (message == null || !XMLObject.class.isInstance(message)) {
            this.log.debug("Message was null or unsupported, can not serialize");
            return null;
        }
        try {
            Element dom = XMLObjectSupport.marshall((XMLObject)((XMLObject)XMLObject.class.cast(message)));
            return SerializeSupport.prettyPrintXML((Node)dom);
        }
        catch (MarshallingException e) {
            this.log.error("Unable to marshall message for logging purposes", (Throwable)e);
            return null;
        }
    }

    protected XMLObject unmarshallMessage(@Nonnull InputStream messageStream) throws MessageDecodingException {
        XMLObject xMLObject;
        block8: {
            InputStream inputStream = messageStream;
            try {
                xMLObject = XMLObjectSupport.unmarshallFromInputStream((ParserPool)this.getParserPool(), (InputStream)messageStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | XMLParserException | UnmarshallingException e) {
                    this.log.error("Error unmarshalling message from input stream: {}", (Object)e.getMessage());
                    throw new MessageDecodingException("Error unmarshalling message from input stream", (Exception)e);
                }
            }
            inputStream.close();
        }
        return xMLObject;
    }
}

