/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.resources;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.commons.RealmsUtils;
import org.apache.syncope.client.console.rest.RealmRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxSearchFieldPanel;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxNumberFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.common.lib.to.ConnIdBundle;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.types.ConnPoolConf;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteSettings;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class ConnectorDetailsPanel
extends WizardStep {
    private static final long serialVersionUID = -2435937897614232137L;
    @SpringBean
    protected RealmRestClient realmRestClient;

    public ConnectorDetailsPanel(final ConnInstanceTO connInstanceTO, final List<ConnIdBundle> bundles) {
        this.setOutputMarkupId(true);
        final boolean fullRealmsTree = SyncopeWebApplication.get().fullRealmsTree(this.realmRestClient);
        AutoCompleteSettings settings = new AutoCompleteSettings();
        settings.setShowCompleteListOnFocusGain(fullRealmsTree);
        settings.setShowListOnEmptyInput(fullRealmsTree);
        AjaxSearchFieldPanel realm = new AjaxSearchFieldPanel(this, "adminRealm", "adminRealm", (IModel)new PropertyModel((Object)connInstanceTO, "adminRealm"), settings){
            private static final long serialVersionUID = -6390474600233486704L;
            final /* synthetic */ ConnectorDetailsPanel this$0;
            {
                this.this$0 = this$0;
                super(id, name, model, settings);
            }

            protected Iterator<String> getChoices(String input) {
                return (RealmsUtils.checkInput((String)input) ? this.this$0.realmRestClient.search(fullRealmsTree ? RealmsUtils.buildBaseQuery() : RealmsUtils.buildKeywordQuery((String)input)).getResult() : List.of()).stream().map(RealmTO::getFullPath).iterator();
            }
        };
        this.add(new Component[]{realm.addRequiredLabel().setOutputMarkupId(true)});
        AjaxTextFieldPanel displayName = new AjaxTextFieldPanel("displayName", "displayName", (IModel)new PropertyModel((Object)connInstanceTO, "displayName"), false);
        this.add(new Component[]{displayName.addRequiredLabel().setOutputMarkupId(true)});
        AjaxTextFieldPanel location = new AjaxTextFieldPanel("location", "location", (IModel)new PropertyModel((Object)connInstanceTO, "location"), false);
        this.add(new Component[]{location.addRequiredLabel().setOutputMarkupId(true).setEnabled(false)});
        AjaxDropDownChoicePanel bundleName = new AjaxDropDownChoicePanel("bundleName", "bundleName", (IModel)new PropertyModel((Object)connInstanceTO, "bundleName"), false);
        bundleName.setEnabled(connInstanceTO.getKey() == null || connInstanceTO.isErrored());
        bundleName.setChoices(bundles.stream().map(ConnIdBundle::getBundleName).distinct().sorted().collect(Collectors.toList()));
        bundleName.getField().setOutputMarkupId(true);
        this.add(new Component[]{bundleName.addRequiredLabel().setOutputMarkupId(true)});
        final AjaxDropDownChoicePanel connectorName = new AjaxDropDownChoicePanel("connectorName", "connectorName", (IModel)new PropertyModel((Object)connInstanceTO, "connectorName"), false);
        connectorName.setEnabled(connInstanceTO.getBundleName() == null || connInstanceTO.isErrored());
        Optional.ofNullable(connInstanceTO.getConnectorName()).ifPresent(v -> connectorName.setChoices(List.of(v)));
        connectorName.getField().setOutputMarkupId(true);
        this.add(new Component[]{connectorName.addRequiredLabel().setOutputMarkupId(true)});
        final AjaxDropDownChoicePanel version = new AjaxDropDownChoicePanel("version", "version", (IModel)new PropertyModel((Object)connInstanceTO, "version"), false);
        version.setEnabled(connInstanceTO.getConnectorName() == null || connInstanceTO.isErrored());
        Optional.ofNullable(connInstanceTO.getVersion()).ifPresent(v -> version.setChoices(List.of(v)));
        version.getField().setOutputMarkupId(true);
        this.add(new Component[]{version.addRequiredLabel().setOutputMarkupId(true)});
        bundleName.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior(this, "change"){
            private static final long serialVersionUID = -1107858522700306810L;
            final /* synthetic */ ConnectorDetailsPanel this$0;
            {
                this.this$0 = this$0;
                super(event);
            }

            protected void onUpdate(AjaxRequestTarget target) {
                connectorName.setEnabled(true);
                List<Pair> connectors = bundles.stream().filter(bundle -> bundle.getBundleName().equals(connInstanceTO.getBundleName())).map(bundle -> Pair.of((Object)bundle.getConnectorName(), (Object)bundle.getVersion())).toList();
                if (connectors.size() == 1) {
                    Pair entry = connectors.getFirst();
                    connInstanceTO.setConnectorName((String)entry.getLeft());
                    connectorName.getField().setModelObject((Object)((String)entry.getLeft()));
                    connectorName.setChoices(List.of((String)entry.getLeft()));
                    connInstanceTO.setVersion((String)entry.getRight());
                    version.getField().setModelObject((Object)((String)entry.getRight()));
                    version.setChoices(List.of((String)entry.getRight()));
                } else {
                    connectorName.setChoices(connectors.stream().map(Pair::getLeft).distinct().sorted().collect(Collectors.toList()));
                    List versions = connectors.stream().map(Pair::getRight).distinct().sorted().collect(Collectors.toList());
                    version.setChoices(versions);
                    if (versions.size() == 1) {
                        connInstanceTO.setVersion((String)versions.getFirst());
                        version.getField().setModelObject((Object)((String)versions.getFirst()));
                    } else {
                        connInstanceTO.setVersion(null);
                        version.getField().setModelObject(null);
                    }
                }
                target.add(new Component[]{version});
                target.add(new Component[]{connectorName});
            }
        }});
        connectorName.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior(this, "change"){
            private static final long serialVersionUID = -1107858522700306810L;
            final /* synthetic */ ConnectorDetailsPanel this$0;
            {
                this.this$0 = this$0;
                super(event);
            }

            protected void onUpdate(AjaxRequestTarget target) {
                List versions = bundles.stream().filter(bundle -> bundle.getBundleName().equals(connInstanceTO.getBundleName()) && bundle.getConnectorName().equals(connInstanceTO.getConnectorName())).map(ConnIdBundle::getVersion).collect(Collectors.toList());
                if (versions.size() == 1) {
                    connInstanceTO.setVersion((String)versions.getFirst());
                    version.getField().setModelObject((Object)((String)versions.getFirst()));
                }
                version.setChoices(versions);
                target.add(new Component[]{version});
            }
        }});
        if (connInstanceTO.getPoolConf() == null) {
            connInstanceTO.setPoolConf(new ConnPoolConf());
        }
        this.add(new Component[]{new AjaxNumberFieldPanel.Builder().min((Number)0).max((Number)Integer.MAX_VALUE).build("connRequestTimeout", "connRequestTimeout", Integer.class, (IModel)new PropertyModel((Object)connInstanceTO, "connRequestTimeout"))});
        this.add(new Component[]{new AjaxNumberFieldPanel.Builder().min((Number)0).max((Number)Integer.MAX_VALUE).build("poolMaxObjects", "poolMaxObjects", Integer.class, (IModel)new PropertyModel((Object)connInstanceTO.getPoolConf(), "maxObjects"))});
        this.add(new Component[]{new AjaxNumberFieldPanel.Builder().min((Number)0).max((Number)Integer.MAX_VALUE).build("poolMinIdle", "poolMinIdle", Integer.class, (IModel)new PropertyModel((Object)connInstanceTO.getPoolConf(), "minIdle"))});
        this.add(new Component[]{new AjaxNumberFieldPanel.Builder().min((Number)0).max((Number)Integer.MAX_VALUE).build("poolMaxIdle", "poolMaxIdle", Integer.class, (IModel)new PropertyModel((Object)connInstanceTO.getPoolConf(), "maxIdle"))});
        this.add(new Component[]{new AjaxNumberFieldPanel.Builder().min((Number)0L).max((Number)Long.MAX_VALUE).build("poolMaxWait", "poolMaxWait", Long.class, (IModel)new PropertyModel((Object)connInstanceTO.getPoolConf(), "maxWait"))});
        this.add(new Component[]{new AjaxNumberFieldPanel.Builder().min((Number)0L).max((Number)Long.MAX_VALUE).build("poolMinEvictableIdleTime", "poolMinEvictableIdleTime", Long.class, (IModel)new PropertyModel((Object)connInstanceTO.getPoolConf(), "minEvictableIdleTimeMillis"))});
    }
}

