/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.rest.ResourceRestClient;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.common.lib.to.ConnObject;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.ItemContainer;
import org.apache.syncope.common.lib.to.LinkedAccountTO;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.rest.api.beans.ConnObjectTOQuery;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.attributes.ThrottlingSettings;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkedAccountDetailsPanel
extends WizardStep {
    private static final long serialVersionUID = 1221037007528732347L;
    @SpringBean
    protected ResourceRestClient resourceRestClient;
    protected static final Logger LOG = LoggerFactory.getLogger(LinkedAccountDetailsPanel.class);
    protected static final int SEARCH_SIZE = 20;
    protected List<String> connObjectKeyFieldValues;

    public LinkedAccountDetailsPanel(LinkedAccountTO linkedAccountTO) {
        this.setOutputMarkupId(true);
        final AjaxDropDownChoicePanel dropdownResourceField = new AjaxDropDownChoicePanel("resource", "resource", (IModel)new PropertyModel((Object)linkedAccountTO, "resource"), false);
        dropdownResourceField.setChoices(this.resourceRestClient.list().stream().filter(resource -> resource.getProvision(AnyTypeKind.USER.name()).flatMap(provision -> Optional.ofNullable(provision.getMapping())).filter(mapping -> !mapping.getItems().isEmpty()).isPresent()).map(ResourceTO::getKey).collect(Collectors.toList()));
        this.add(new Component[]{dropdownResourceField.setNullValid(false).addRequiredLabel().setOutputMarkupId(true)});
        final String connObjectKeyFieldId = "connObjectKeyValue";
        final AjaxTextFieldPanel connObjectKeyField = new AjaxTextFieldPanel("connObjectKeyValue", "connObjectKeyValue", (IModel)new PropertyModel((Object)linkedAccountTO, "connObjectKeyValue"), false);
        connObjectKeyField.setOutputMarkupId(true);
        connObjectKeyField.addRequiredLabel();
        connObjectKeyField.setChoices(List.of());
        connObjectKeyField.setEnabled(false);
        this.add(new Component[]{connObjectKeyField});
        dropdownResourceField.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior(this, "change"){
            private static final long serialVersionUID = -1107858522700306810L;
            final /* synthetic */ LinkedAccountDetailsPanel this$0;
            {
                this.this$0 = this$0;
                super(event);
            }

            protected void onUpdate(AjaxRequestTarget target) {
                boolean enabled = dropdownResourceField.getModelObject() != null && !((String)((Object)dropdownResourceField.getModelObject())).isEmpty();
                connObjectKeyField.setEnabled(enabled);
                if (enabled) {
                    this.this$0.setConnObjectFieldChoices(connObjectKeyField, (String)((Object)dropdownResourceField.getModelObject()), null);
                }
                target.add(new Component[]{connObjectKeyField});
            }
        }});
        connObjectKeyField.getField().setMarkupId(connObjectKeyFieldId);
        connObjectKeyField.getField().add(new Behavior[]{new AjaxEventBehavior(this, "keydown"){
            private static final long serialVersionUID = 3533589614190959822L;
            final /* synthetic */ LinkedAccountDetailsPanel this$0;
            {
                this.this$0 = this$0;
                super(event);
            }

            protected void onEvent(AjaxRequestTarget target) {
                String searchTerm = connObjectKeyField.getField().getInput();
                if (StringUtils.isNotBlank((CharSequence)searchTerm) && searchTerm.length() > 1) {
                    this.this$0.setConnObjectFieldChoices(connObjectKeyField, (String)((Object)dropdownResourceField.getModelObject()), searchTerm);
                    target.appendJavaScript((CharSequence)(this.this$0.connObjectKeyFieldValues.isEmpty() ? "$('#" + connObjectKeyFieldId + "-autocomplete-container').hide();" : "var simulatedEvent = new KeyboardEvent('keydown', {keyCode: 40, which: 40}); document.getElementById('" + connObjectKeyFieldId + "').dispatchEvent(simulatedEvent);"));
                }
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                AjaxCallListener listener = new AjaxCallListener(){
                    private static final long serialVersionUID = 2208168001920794667L;

                    public CharSequence getPrecondition(Component component) {
                        return "var keycode = Wicket.Event.keyCode(attrs.event); if ((keycode == 40) || (keycode == 38)) {return false;} return true;";
                    }
                };
                attributes.getAjaxCallListeners().add(listener);
                attributes.setThrottlingSettings(new ThrottlingSettings("id", Duration.of(1L, ChronoUnit.SECONDS), true));
            }
        }});
    }

    private void setConnObjectFieldChoices(AjaxTextFieldPanel ajaxTextFieldPanel, String resource, String searchTerm) {
        MutableObject resourceRemoteKey = new MutableObject((Object)"__NAME__");
        try {
            this.resourceRestClient.read(resource).getProvision(AnyTypeKind.USER.name()).flatMap(provision -> Optional.ofNullable(provision.getMapping())).flatMap(ItemContainer::getConnObjectKeyItem).ifPresent(arg_0 -> LinkedAccountDetailsPanel.lambda$setConnObjectFieldChoices$1((Mutable)resourceRemoteKey, arg_0));
        }
        catch (Exception ex) {
            LOG.error("While reading mapping for resource {}", (Object)resource, (Object)ex);
        }
        ConnObjectTOQuery.Builder builder = new ConnObjectTOQuery.Builder().size(Integer.valueOf(20));
        if (StringUtils.isNotBlank((CharSequence)searchTerm)) {
            builder.fiql(SyncopeClient.getConnObjectTOFiqlSearchConditionBuilder().is((String)resourceRemoteKey.get()).equalTo(searchTerm + "*", new String[0]).query()).build();
        }
        Pair<String, List<ConnObject>> items = this.resourceRestClient.searchConnObjects(resource, AnyTypeKind.USER.name(), builder, (SortParam<String>)new SortParam((Object)((String)resourceRemoteKey.get()), true));
        this.connObjectKeyFieldValues = ((List)items.getRight()).stream().map(arg_0 -> LinkedAccountDetailsPanel.lambda$setConnObjectFieldChoices$2((Mutable)resourceRemoteKey, arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        ajaxTextFieldPanel.setChoices(this.connObjectKeyFieldValues);
    }

    private static /* synthetic */ String lambda$setConnObjectFieldChoices$2(Mutable resourceRemoteKey, ConnObject item) {
        return item.getAttr((String)resourceRemoteKey.get()).map(attr -> (String)attr.getValues().getFirst()).orElse(null);
    }

    private static /* synthetic */ void lambda$setConnObjectFieldChoices$1(Mutable resourceRemoteKey, Item connObjectKeyItem) {
        resourceRemoteKey.setValue((Object)connObjectKeyItem.getExtAttrName());
    }
}

